% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpHistBin.R
\docType{data}
\name{mlr_pipeops_histbin}
\alias{mlr_pipeops_histbin}
\alias{PipeOpHistBin}
\title{PipeOpHistBin}
\format{\code{\link{R6Class}} object inheriting from \code{\link{PipeOpTaskPreprocSimple}}/\code{\link{PipeOpTaskPreproc}}/\code{\link{PipeOp}}.}
\description{
Splits numeric features into equally spaced bins.
See \code{\link[graphics:hist]{graphics::hist()}} for details.
}
\section{Construction}{
\preformatted{PipeOpHistBin$new(id = "histbin", param_vals = list())
}
\itemize{
\item \code{id} :: \code{character(1)}\cr
Identifier of resulting object, default \code{"histbin"}.
\item \code{param_vals} :: named \code{list}\cr
List of hyperparameter settings, overwriting the hyperparameter settings that would otherwise be set during construction. Default \code{list()}.
}
}

\section{Input and Output Channels}{

Input and output channels are inherited from \code{\link{PipeOpTaskPreproc}}.

The output is the input \code{\link[mlr3:Task]{Task}} with all affected numeric features replaced by their binned versions.
}

\section{State}{

The \code{$state} is a named \code{list} with the \code{$state} elements inherited from \code{\link{PipeOpTaskPreproc}}, as well as:
\itemize{
\item \code{bins} :: \code{list} \cr
List of intervals representing the bins for each numeric feature.
}
}

\section{Parameters}{

The parameters are the parameters inherited from \code{\link{PipeOpTaskPreproc}}, as well as:
\itemize{
\item \code{bins} :: \code{character(1)} | \code{numeric} | \code{function} \cr
Either a \code{character(1)} string naming an algorithm to compute the number of cells,
a \code{numeric(1)} giving the number of breaks for the histogram,
a vector \code{numeric} giving the breakpoints between the histogram cells, or
a \code{function} to compute the vector of breakpoints or to compute the number
of cells. Default is algorithm \code{"Sturges"} (see \code{\link[grDevices:nclass.Sturges]{grDevices::nclass.Sturges()}}).
For details see \code{\link[graphics:hist]{hist()}}.
}
}

\section{Internals}{

Uses the \code{\link[graphics:hist]{graphics::hist}} function.
}

\section{Methods}{

Only methods inherited from \code{\link{PipeOpTaskPreprocSimple}}/\code{\link{PipeOpTaskPreproc}}/\code{\link{PipeOp}}.
}

\examples{
library("mlr3")

task = tsk("iris")
pop = po("histbin")

task$data()
pop$train(list(task))[[1]]$data()

pop$state
}
\seealso{
Other PipeOps: \code{\link{PipeOpEnsemble}},
  \code{\link{PipeOpImpute}},
  \code{\link{PipeOpTaskPreproc}}, \code{\link{PipeOp}},
  \code{\link{mlr_pipeops_boxcox}},
  \code{\link{mlr_pipeops_branch}},
  \code{\link{mlr_pipeops_chunk}},
  \code{\link{mlr_pipeops_classbalancing}},
  \code{\link{mlr_pipeops_classifavg}},
  \code{\link{mlr_pipeops_colapply}},
  \code{\link{mlr_pipeops_collapsefactors}},
  \code{\link{mlr_pipeops_copy}},
  \code{\link{mlr_pipeops_encodelmer}},
  \code{\link{mlr_pipeops_encode}},
  \code{\link{mlr_pipeops_featureunion}},
  \code{\link{mlr_pipeops_filter}},
  \code{\link{mlr_pipeops_fixfactors}},
  \code{\link{mlr_pipeops_ica}},
  \code{\link{mlr_pipeops_imputehist}},
  \code{\link{mlr_pipeops_imputemean}},
  \code{\link{mlr_pipeops_imputemedian}},
  \code{\link{mlr_pipeops_imputenewlvl}},
  \code{\link{mlr_pipeops_imputesample}},
  \code{\link{mlr_pipeops_kernelpca}},
  \code{\link{mlr_pipeops_learner}},
  \code{\link{mlr_pipeops_missind}},
  \code{\link{mlr_pipeops_modelmatrix}},
  \code{\link{mlr_pipeops_mutate}},
  \code{\link{mlr_pipeops_nop}},
  \code{\link{mlr_pipeops_pca}},
  \code{\link{mlr_pipeops_quantilebin}},
  \code{\link{mlr_pipeops_regravg}},
  \code{\link{mlr_pipeops_removeconstants}},
  \code{\link{mlr_pipeops_scalemaxabs}},
  \code{\link{mlr_pipeops_scalerange}},
  \code{\link{mlr_pipeops_scale}},
  \code{\link{mlr_pipeops_select}},
  \code{\link{mlr_pipeops_smote}},
  \code{\link{mlr_pipeops_spatialsign}},
  \code{\link{mlr_pipeops_subsample}},
  \code{\link{mlr_pipeops_unbranch}},
  \code{\link{mlr_pipeops_yeojohnson}},
  \code{\link{mlr_pipeops}}
}
\concept{PipeOps}
\keyword{datasets}
