% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mplus.print.R
\name{mplus.print}
\alias{mplus.print}
\title{Print Mplus Output}
\usage{
mplus.print(x, print = c("all", "input", "result"),
            input = c("all", "default", "data", "variable", "define",
                      "analysis", "model", "montecarlo", "mod.pop", "mod.cov",
                      "mod.miss", "message"),
             result = c("all", "default", "summary.analysis.short",
                        "summary.data.short", "random.starts", "summary.fit",
                        "mod.est", "fit", "class.count", "classif",
                        "mod.result", "total.indirect"),
             exclude = NULL, variable = FALSE, not.input = TRUE, not.result = TRUE,
             write = NULL, append = TRUE, check = TRUE, output = TRUE)
}
\arguments{
\item{x}{a character string indicating the name of the Mplus output
file with or without the file extension \code{.out}, e.g.,
\code{"Mplus_Output.out"} or \code{"Mplus_Output"}.
Alternatively, a \code{misty.object} of type \code{mplus}
can be specified, i.e., result object of the \code{mplus.print()},
\code{mplus()} or \code{mplus.update()} function.}

\item{print}{a character vector indicating which section to show, i.e.
\code{"all"} for input and result sections, \code{"input"}
for input command section only, and \code{"result"} (default)
for result sections only}

\item{input}{a character vector specifying Mplus input command sections}

\item{result}{a character vector specifying Mplus result sections included
in the output (see 'Details').}

\item{exclude}{a character vector specifying Mplus input command or result
sections excluded from the output (see 'Details').}

\item{variable}{logical: if \code{TRUE}, names of the variables in the data
set (\code{NAMES} option) specified in the \code{VARIABLE:}
command section are shown. By default, names of the variables
in the data set are excluded from the output unless all variables
are used in the analysis (i.e., no \code{USEVARIABLES} option
specified in the Mplus input file).}

\item{not.input}{logical: if \code{TRUE} (default), character vector indicating
the input commands not requested are shown on the console.}

\item{not.result}{logical: if \code{TRUE} (default), character vector indicating
the result sections not requested are shown on the console.}

\item{write}{a character string naming a file for writing the output into
 a text file with file extension \code{".txt"} (e.g.,
\code{"Output.txt"}).}

\item{append}{logical: if \code{TRUE} (default), output will be appended
to an existing text file with extension \code{.txt} specified
in \code{write}, if \code{FALSE} existing text file will be
overwritten.}

\item{check}{logical: if \code{TRUE} (default), argument specification is
checked.}

\item{output}{logical: if \code{TRUE} (default), output is shown on the
console.}
}
\value{
Returns an object of class \code{misty.object}, which is a list with following
entries:

\item{\code{call}}{function call}
\item{\code{type}}{type of analysis}
\item{\code{x}}{character string or misty object}
\item{\code{args}}{specification of function arguments}
\item{\code{print}}{print objects}
\item{\code{notprint}}{character vectors indicating the input commands and
            result sections not requested}
\item{\code{result}}{list with input command sections (\code{input}) and result
                     sections (\code{input})}
}
\description{
This function prints the input command sections and the result sections of a Mplus
output file (\code{.out}) on the R console. By default, the function prints
selected result sections, e.g., short \code{Summary of Analysis}, short
\code{Summary of Data}, \code{Model Fit Information}, and \code{Model Results}.
}
\details{
\describe{
\item{\strong{Input Command Sections}}{Following input command sections can be
selected by using the \code{input} argument or excluded by using the \code{exclude}
argument:
   \itemize{
      \item{\code{"title"}} for the \code{TITLE} command used to provide a title
      for the analysis.
      \item{\code{"data"}} for the \code{DATA} command used to provide information
      about the data set to be analyzed.
      \item{\code{"data.imp"}} for the \code{DATA IMPUTATION} command used to
      create a set of imputed data sets using multiple imputation methodology.
      \item{\code{"data.wl"}} for the \code{DATA WIDETOLONG} command used to
      rearrange data from a multivariate wide format to a univariate long format.
      \item{\code{"data.lw"}} for the \code{DATA LONGTOWIDE} command used to
      rearrange a univariate long format to a multivariate wide format.
      \item{\code{"data.tp"}} for the \code{DATA TWOPART} command used to create
      a binary and a continuous variable from a continuous variable with a floor
      effect for use in two-part modeling.
      \item{\code{"data.miss"}} for the \code{DATA MISSING} command used to
      create a set of binary variables that are indicators of missing data or
      dropout for another set of variables.
      \item{\code{"data.surv"}} for the \code{DATA SURVIVAL} command used to
      create variables for discrete-time survival modeling.
      \item{\code{"data.coh"}} for the \code{DATA COHORT} command used to
      rearrange longitudinal data from a format where time points represent
      measurement occasions to a format where time points represent age or
      another time-related variable,
      \item{\code{"variable"}} for the \code{VARIABLE} command used to provide
      information about the variables in the data set to be analyzed.
      \item{\code{"define"}} for the \code{DEFINE} command used to transform
      existing variables and to create new variables.
      \item{\code{"analysis"}} for the \code{ANALYSIS} command used to describe
      the technical details for the analysis.
      \item{\code{"model"}} \code{MODEL} for the command used to describe the
      model to be estimated.
      \item{\code{"mod.ind"}} for the \code{MODEL INDIRECT} command used to
      request indirect and directed effects and their standard errors.
      \item{\code{"mod.test"}} for the \code{MODEL TEST} command used to
      test restrictions on the parameters in the \code{MODEL} and \code{MODEL CONSTRAINT}
      commands using the Wald chi-square test.
      \item{\code{"mod.prior"}} for the \code{MODEL PRIORS} command used with
     \code{ESTIMATOR IS BAYES} to specify the prior distribution for each
      parameter.
      \item{\code{"montecarlo"}} for the \code{MONTECARLO} command used to set
      up and carry out a Monte Carlo simulation study.
      \item{\code{"mod.pop"}} for the \code{MODEL POPULATION} command used
      to provide the population parameter values to be used in data generation
      using the options of the \code{MODEL} command.
      \item{\code{"mod.cov"}} for the \code{MODEL COVERAGE} used to provide
      the population parameter values to be used for computing coverage.
      \item{\code{"mod.miss"}}  for the \code{MODEL MISSING} command used to
      provide information about the population parameter values for the missing
      data model to be used in the generation of data.
      \item{\code{"output"}} for the  for the \code{OUTPUT} command used to
      request additional output beyond that included as the default.
      \item{\code{"savedata"}} for the \code{SAVEDATA} command used to save
      the analysis data and/or a variety of model results in an ASCII file for
      future use.
      \item{\code{"plot"}} for the \code{PLOT} command used to requested graphical
      displays of observed data and analysis results.
      \item{\code{"message"}} for warning and error messages that have been
      generated by the program after the input command sections.
   }
Note that all input command sections are requested by specifying \code{input = "all"}.
The \code{input} argument is also used to select one (e.g., \code{input = "model"})
or more than one input command sections (e.g., \code{input = c("analysis", "model")}),
or to request input command sections in addition to the default setting (e.g.,
\code{input = c("default", "output")}). The \code{exclude} argument is used
to exclude input command sections from the output (e.g., exclude = "variable").
}
\item{\strong{Result Sections}}{Following result sections can be selected by
using the \code{result} argument or excluded by using the \code{exclude}
argument:
   \itemize{
      \item{\code{"summary.analysis"}} for the \code{SUMMARY OF ANALYSIS} section..
      \item{\code{"summary.analysis.short"}} for a short \code{SUMMARY OF ANALYSIS} section including the number of observations, number of groups, estimator, and optimization algorithm.
      \item{\code{"summary.data"}} for the \code{SUMMARY OF DATA} section indicating.
      \item{\code{"summary.data.short"}} for a short \code{SUMMARY OF DATA} section including number of clusters, average cluster size, and estimated intraclass correlations.
      \item{\code{"prop.count"}} for the \code{UNIVARIATE PROPORTIONS AND COUNTS FOR CATEGORICAL VARIABLES} section.
      \item{\code{"summary.censor"}} for the \code{SUMMARY OF CENSORED LIMITS} section.
      \item{\code{"prop.zero"}} for the \code{COUNT PROPORTION OF ZERO, MINIMUM AND MAXIMUM VALUES} section.
      \item{\code{"crosstab"}} for the \code{CROSSTABS FOR CATEGORICAL VARIABLES} section.
      \item{\code{"summary.miss"}} for the \code{SUMMARY OF MISSING DATA PATTERNS} section.
      \item{\code{"coverage"}} for the \code{COVARIANCE COVERAGE OF DATA} section.
      \item{\code{"basic"}} for the \code{RESULTS FOR BASIC ANALYSIS} section.
      \item{\code{"sample.stat"}} for the \code{SAMPLE STATISTICS} section.
      \item{\code{"uni.sample.stat"}} for the \code{UNIVARIATE SAMPLE STATISTICS} section.
      \item{\code{"random.starts"}} for the \code{RANDOM STARTS RESULTS} section.
      \item{\code{"summary.fit"}} for the \code{SUMMARY OF MODEL FIT INFORMATION} section.
      \item{\code{"mod.est"}} for the \code{THE MODEL ESTIMATION TERMINATED NORMALLY} message and warning messages from the model estimation.
      \item{\code{"fit"}} for the \code{MODEL FIT INFORMATION} section.
      \item{\code{"class.count"}} for the \code{FINAL CLASS COUNTS AND PROPORTIONS FOR THE LATENT CLASSES} section.
      \item{\code{"ind.means"}} for the \code{LATENT CLASS INDICATOR MEANS AND PROBABILITIES} section.
      \item{\code{"trans.prob"}} for the \code{LATENT TRANSITION PROBABILITIES BASED ON THE ESTIMATED MODEL} section.
      \item{\code{"classif"}} for the \code{CLASSIFICATION QUALITY} section.
      \item{\code{"mod.result"}} for the \code{MODEL RESULTS} and \code{RESULTS FOR EXPLORATORY FACTOR ANALYSIS} section.
      \item{\code{"odds.ratio"}} for the \code{LOGISTIC REGRESSION ODDS RATIO RESULTS} section.
      \item{\code{"prob.scale"}} for the \code{RESULTS IN PROBABILITY SCALE} section.
      \item{\code{"ind.odds.ratio"}} for the \code{LATENT CLASS INDICATOR ODDS RATIOS FOR THE LATENT CLASSES} section.
      \item{\code{"alt.param"}} for the \code{ALTERNATIVE PARAMETERIZATIONS FOR THE CATEGORICAL LATENT VARIABLE REGRESSION} section.
      \item{\code{"irt.param"}} for the \code{IRT PARAMETERIZATION} section.
      \item{\code{"brant.wald"}} for the \code{BRANT WALD TEST FOR PROPORTIONAL ODDS} section.
      \item{\code{"std.mod.result"}} for the \code{STANDARDIZED MODEL RESULTS} section.
      \item{\code{"rsquare"}} for the \code{R-SQUARE} section.
      \item{\code{"total.indirect"}} for the \code{TOTAL, TOTAL INDIRECT, SPECIFIC INDIRECT, AND DIRECT EFFECTS} section.
      \item{\code{"std.total.indirect"}} for the \code{STANDARDIZED TOTAL, TOTAL INDIRECT, SPECIFIC INDIRECT, AND DIRECT EFFECTS} section.
      \item{\code{"std.mod.result.cluster"}} for the \code{WITHIN-LEVEL STANDARDIZED MODEL RESULTS FOR CLUSTER} section.
      \item{\code{"fs.comparison"}} for the \code{BETWEEN-LEVEL FACTOR SCORE COMPARISONS} section.
      \item{\code{"conf.mod.result"}} for the \code{CONFIDENCE INTERVALS OF MODEL RESULTS} section.
      \item{\code{"conf.std.conf"}} for the \code{CONFIDENCE INTERVALS OF STANDARDIZED MODEL RESULTS} section.
      \item{\code{"conf.total.indirect"}} for the \code{CONFIDENCE INTERVALS OF TOTAL, TOTAL INDIRECT, SPECIFIC INDIRECT, AND DIRECT EFFECTS} section.
      \item{\code{"conf.odds.ratio"}} for the \code{CONFIDENCE INTERVALS FOR THE LOGISTIC REGRESSION ODDS RATIO RESULTS} section.
      \item{\code{"modind"}} for the \code{MODEL MODIFICATION INDICES} section.
      \item{\code{"resid"}} for the \code{RESIDUAL OUTPUT} section.
      \item{\code{"logrank"}} for the \code{LOGRANK OUTPUT} section.
      \item{\code{"tech1"}} for the \code{TECHNICAL 1 OUTPUT} section.
      \item{\code{"tech2"}} for the \code{TECHNICAL 2 OUTPUT} section.
      \item{\code{"tech3"}} for the \code{TECHNICAL 3 OUTPUT} section.
      \item{\code{"h1.tech3"}} for the \code{H1 TECHNICAL 3 OUTPUT} section.
      \item{\code{"tech4"}} for the \code{TECHNICAL 4 OUTPUT} section.
      \item{\code{"tech5"}} for the \code{TECHNICAL 5 OUTPUT} section.
      \item{\code{"tech6"}} for the \code{TECHNICAL 6 OUTPUT} section.
      \item{\code{"tech7"}} for the \code{TECHNICAL 7 OUTPUT} section.
      \item{\code{"tech8"}} for the \code{TECHNICAL 8 OUTPUT} section.
      \item{\code{"tech9"}} for the \code{TECHNICAL 9 OUTPUT} section.
      \item{\code{"tech10"}} for the \code{TECHNICAL 10 OUTPUT} section.
      \item{\code{"tech11"}} for the \code{TECHNICAL 11 OUTPUT} section.
      \item{\code{"tech12"}} for the \code{TECHNICAL 12 OUTPUT} section.
      \item{\code{"tech13"}} for the \code{TECHNICAL 13 OUTPUT} section.
      \item{\code{"tech14"}} for the \code{TECHNICAL 14 OUTPUT} section.
      \item{\code{"tech15"}} for the \code{TECHNICAL 15 OUTPUT} section.
      \item{\code{"tech16"}} for the \code{TECHNICAL 16 OUTPUT} section.
      \item{\code{"svalues"}} for the \code{MODEL COMMAND WITH FINAL ESTIMATES USED AS STARTING VALUES} section.
      \item{\code{"stat.fscores"}} for the \code{SAMPLE STATISTICS FOR ESTIMATED FACTOR SCORES} section.
      \item{\code{"summary.fscores"}} for the \code{SUMMARY OF FACTOR SCORES} section.
      \item{\code{"pv"}} for the \code{SUMMARIES OF PLAUSIBLE VALUES} section.
      \item{\code{"plotinfo"}} for the \code{PLOT INFORMATION} section.
      \item{\code{"saveinfo"}} for the \code{SAVEDATA INFORMATION} section.
   }
Note that all result sections are requested by specifying \code{result = "all"}.
The \code{result} argument is also used to select one (e.g., \code{result = "mod.result"})
or more than one result sections (e.g., \code{result = c("mod.result", "std.mod.result")}),
or to request result sections in addition to the default setting (e.g.,
\code{result = c("default", "odds.ratio")}). The \code{exclude} argument is used
to exclude result sections from the output (e.g., \code{exclude = "mod.result"}).
}
}
}
\examples{
\dontrun{

#----------------------------------------------------------------------------
# Mplus Example 3.1: Linear Regression

# Example 1a: Default setting
mplus.print("ex3.1.out")

# Example 1b:  Print result section only
mplus.print("ex3.1.out", print = "result")

# Example 1c: Print MODEL RESULTS only
mplus.print("ex3.1.out", print = "result", result = "mod.result")

# Example 1d: Print UNIVARIATE SAMPLE STATISTICS in addition to the default setting
mplus.print("ex3.1.out", result = c("default", "uni.sample.stat"))

# Example 1e: Exclude MODEL FIT INFORMATION section
mplus.print("ex3.1.out", exclude = "fit")

# Example 1f: Print all result sections, but exclude MODEL FIT INFORMATION section
mplus.print("ex3.1.out", result = "all", exclude = "fit")

# Example 1g: Print result section in a different order
mplus.print("ex3.1.out", result = c("mod.result", "fit", "summary.analysis"))

#----------------------------------------------------------------------------
# misty.object of type 'mplus.print'

# Example 2
# Create misty.object
object <- mplus.print("ex3.1.out", output = FALSE)

# Print misty.object
mplus.print(object)

#----------------------------------------------------------------------------
# Write Results

# # Example 3: Write Results into a text file
mplus.print("ex3.1.out", write = "Output_3-1.txt")
}
}
\references{
Muthen, L. K., & Muthen, B. O. (1998-2017). \emph{Mplus User's Guide} (8th ed.).
Muthen & Muthen.
}
\seealso{
\code{\link{read.mplus}}, \code{\link{write.mplus}}, \code{\link{mplus}},
\code{\link{mplus.update}}, \code{\link{mplus.plot}}, \code{\link{mplus.bayes}},
\code{\link{mplus.run}}, \code{\link{mplus.lca}}
}
\author{
Takuya Yanagida
}
