% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/track-management.R
\name{gtrack.info}
\alias{gtrack.info}
\title{Returns information about a track}
\usage{
gtrack.info(track = NULL, validate = FALSE)
}
\arguments{
\item{track}{track name}

\item{validate}{if TRUE, validates the track index file integrity (for indexed tracks). Default: FALSE}
}
\value{
A list that contains track properties
}
\description{
Returns information about a track.
}
\details{
Returns information about the track (type, dimensions, size in bytes, etc.).
The fields in the returned value vary depending on the type of the track.
}
\examples{
\dontshow{
options(gmax.processes = 2)
}

gdb.init_examples()
gtrack.info("dense_track")
gtrack.info("rects_track")

}
\seealso{
\code{\link{gtrack.exists}}, \code{\link{gtrack.ls}}
}
\keyword{~info}
\keyword{~property}
\keyword{~track}
