% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testinfo.R
\name{testinfo}
\alias{testinfo}
\title{Function to calculate test information}
\usage{
testinfo(x, Theta, degrees = NULL, group = NULL, individual = FALSE,
  which.items = 1:extract.mirt(x, "nitems"))
}
\arguments{
\item{x}{an object of class 'SingleGroupClass', or an object of class 'MultipleGroupClass' if a suitable
\code{group} input were supplied}

\item{Theta}{a matrix of latent trait values}

\item{degrees}{a vector of angles in degrees that are between 0 and 90.
Only applicable when the input object is multidimensional}

\item{group}{group argument to pass to \code{\link{extract.group}} function. Required when the input object is
a multiple-group model}

\item{individual}{logical; return a data.frame of information traceline for each item?}

\item{which.items}{an integer vector indicating which items to include in the expected information function.
Default uses all possible items}
}
\description{
Given an estimated model compute the test information.
}
\examples{

dat <- expand.table(deAyala)
(mirt(dat, 1, '2PL', pars = 'values'))
mod <- mirt(dat, 1, '2PL', constrain = list(c(1,5,9,13,17)))

Theta <- matrix(seq(-4,4,.01))
tinfo <- testinfo(mod, Theta)
plot(Theta, tinfo, type = 'l')

\dontrun{

#compare information loss between two tests
tinfo_smaller <- testinfo(mod, Theta, which.items = 3:5)

#removed item informations
plot(Theta, iteminfo(extract.item(mod, 1), Theta), type = 'l')
plot(Theta, iteminfo(extract.item(mod, 2), Theta), type = 'l')

#most loss of info around -1 when removing items 1 and 2; expected given item info functions
plot(Theta, tinfo_smaller - tinfo, type = 'l')


}
}
\references{
Chalmers, R., P. (2012). mirt: A Multidimensional Item Response Theory
Package for the R Environment. \emph{Journal of Statistical Software, 48}(6), 1-29.
\doi{10.18637/jss.v048.i06}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
\keyword{information}
