% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_mgcv_smooth_1D.R,
%   R/plot_multi_mgcv_smooth_1D.R
\name{plot.mgcv.smooth.1D}
\alias{plot.mgcv.smooth.1D}
\alias{plot.multi.mgcv.smooth.1D}
\title{Plotting one dimensional smooth effects}
\usage{
\method{plot}{mgcv.smooth.1D}(x, n = 100, xlim = NULL, maxpo = 10000,
  trans = identity, unconditional = FALSE, seWithMean = FALSE,
  nsim = 0, ...)

\method{plot}{multi.mgcv.smooth.1D}(x, n = 100, xlim = NULL,
  maxpo = 10000, trans = identity, unconditional = FALSE,
  seWithMean = FALSE, asFact = NULL, ...)
}
\arguments{
\item{x}{a smooth effect object, extracted using \link[mgcViz:sm]{mgcViz::sm}.}

\item{n}{number of grid points used to compute main effect and c.i. lines.
For a nice smooth plot this needs to be several times the estimated degrees of
freedom for the smooth.}

\item{xlim}{if supplied then this pair of numbers are used as the x limits for the plot.}

\item{maxpo}{maximum number of residuals points that will be used by layers such as
\code{resRug()} and \code{resPoints()}. If number of datapoints > \code{maxpo},
then a subsample of \code{maxpo} points will be taken.}

\item{trans}{monotonic function to apply to the smooth and residuals, before plotting.
Monotonicity is not checked.}

\item{unconditional}{if \code{TRUE} then the smoothing parameter uncertainty corrected covariance
matrix is used to compute uncertainty bands, if available.
Otherwise the bands treat the smoothing parameters as fixed.}

\item{seWithMean}{if TRUE the component smooths are shown with confidence intervals that
include the uncertainty about the overall mean. If FALSE then the uncertainty
relates purely to the centred smooth itself. Marra and Wood (2012) suggests
that TRUE results in better coverage performance, and this is also suggested
by simulation.}

\item{nsim}{number of smooth effect curves to be simulated from the posterior distribution.
These can be plotted using the \link{l_simLine} layer. See Examples section below.}

\item{...}{currently unused.}

\item{asFact}{determines whether to use a factor or colour bar legend for plot.multi.mgcv.smooth.1D.
When working with models fitted with \link{mqgamV}, the default is
\code{FALSE} for less than 10 quantiles, \code{TRUE} otherwise. For other models the
default is \code{TRUE}.}
}
\value{
An objects of class \code{plotSmooth}.
}
\description{
Plotting method for one dimensional smooth effects.
}
\examples{
library(mgcViz)
n  <- 1e3
x1 <- rnorm(n)
x2 <- rnorm(n)
dat <- data.frame("x1" = x1, "x2" = x2,
                  "y" = sin(x1) + 0.5 * x2^2 + pmax(x2, 0.2) * rnorm(n))
b <- bamV(y ~ s(x1)+s(x2), data = dat, method = "fREML", aGam = list(discrete = TRUE))

o <- plot(sm(b, 1), nsim = 50) # 50 posterior simulations 

# Plot with fitted effect + posterior simulations + rug on x axis
( o <- o + l_simLine() + l_fitLine(colour = "red") + 
       l_rug(alpha = 0.8) )

# Add CI lines at 1*sigma and 5*sigma
( o <- o + l_ciLine(mul = 1) + l_ciLine(mul = 5, colour = "blue", linetype = 2) )

# Add partial residuals and change theme
( o + l_points(shape = 19, size = 1, alpha = 0.2) + theme_classic() )

# Get second effect plot
o2 <- plot( sm(b, 2) )

# Plot it with polygon for partial residuals
o2 + l_ciPoly(mul = 5, fill = "light blue") + 
  l_fitLine(linetype = 2, colour = "red")

# Plot is with conditional density of partial residuals
o2 + l_dens(type = "cond", alpha = 0.9)  + 
  l_fitLine(linetype = 2, colour = "red")
  
\dontrun{
########
# Quantile GAM example
########
# Fit model
b <- mqgamV(y ~ s(x1) + s(x2), qu = c(0.2, 0.5, 0.8), data = dat)

plot(sm(b, 1)) + l_fitLine(linetype = 2) + l_rug(colour = "blue")
}

}
\references{
Marra, G and S.N. Wood (2012) Coverage Properties of Confidence Intervals for
Generalized Additive Model Components. Scandinavian Journal of Statistics.
}
