% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/google-analytics.R
\name{get_ga_metadata}
\alias{get_ga_metadata}
\title{Get metadata associated Google Analytics property}
\usage{
get_ga_metadata(property_id, token = NULL)
}
\arguments{
\item{property_id}{a GA property. Looks like '123456789' Can be obtained from running `get_ga_properties()`}

\item{token}{credentials for access to Google using OAuth.  `authorize("google")`}
}
\value{
A list showing the metadata types available for the Google Analytics property. This can be used to craft an API request.
}
\description{
This is a function to get the Google Analytics accounts that this user has access to
}
\examples{
\dontrun{

authorize("google")
accounts <- get_ga_user()

properties_list <- get_ga_properties(account_id = accounts$id[1])

property_id <- gsub("properties/", "", properties_list$name[1])
property_metadata <- get_ga_metadata(property_id = property_id)
}
}
