% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.data_list}
\alias{plot.data_list}
\title{Plot of feature values in a data list}
\usage{
\method{plot}{data_list}(
  x,
  y = NULL,
  cluster_rows = TRUE,
  cluster_columns = TRUE,
  heatmap_legend_param = NULL,
  row_title = "Observation",
  column_title = "Feature",
  show_row_names = FALSE,
  ...
)
}
\arguments{
\item{x}{A \code{data_list} object.}

\item{y}{Optional argument to \code{plot}, not used in this method.}

\item{cluster_rows}{Logical indicating whether to cluster the rows
(observations).}

\item{cluster_columns}{Logical indicating whether to cluster the columns
(features).}

\item{heatmap_legend_param}{A list of parameters for the heatmap legend.}

\item{row_title}{Title for the rows (observations).}

\item{column_title}{Title for the columns (features).}

\item{show_row_names}{Logical indicating whether to show row names.}

\item{...}{Additional arguments passed to \code{ComplexHeatmap::Heatmap()}.}
}
\value{
A heatmap visualization of feature values.
}
\description{
This plot, built on \code{ComplexHeatmap::Heatmap()}, visualizes the feature
values in a data list as a continuous heatmap with observations along the
columns and features along the rows.
}
