% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coclustering.R
\name{cocluster_heatmap}
\alias{cocluster_heatmap}
\title{Heatmap of observation co-clustering across resampled data}
\usage{
cocluster_heatmap(
  cocluster_df,
  cluster_rows = TRUE,
  cluster_columns = TRUE,
  show_row_names = FALSE,
  show_column_names = FALSE,
  dl = NULL,
  data = NULL,
  left_bar = NULL,
  right_bar = NULL,
  top_bar = NULL,
  bottom_bar = NULL,
  left_hm = NULL,
  right_hm = NULL,
  top_hm = NULL,
  bottom_hm = NULL,
  annotation_colours = NULL,
  min_colour = NULL,
  max_colour = NULL,
  ...
)
}
\arguments{
\item{cocluster_df}{A data frame containing co-clustering data for a single
cluster solution. This object is generated by the \code{calculate_coclustering}
function.}

\item{cluster_rows}{Argument passed to \code{ComplexHeatmap::Heatmap()}.}

\item{cluster_columns}{Argument passed to \code{ComplexHeatmap::Heatmap()}.}

\item{show_row_names}{Argument passed to \code{ComplexHeatmap::Heatmap()}.}

\item{show_column_names}{Argument passed to \code{ComplexHeatmap::Heatmap()}.}

\item{dl}{See ?similarity_matrix_heatmap.}

\item{data}{See ?similarity_matrix_heatmap.}

\item{left_bar}{See ?similarity_matrix_heatmap.}

\item{right_bar}{See ?similarity_matrix_heatmap.}

\item{top_bar}{See ?similarity_matrix_heatmap.}

\item{bottom_bar}{See ?similarity_matrix_heatmap.}

\item{left_hm}{See ?similarity_matrix_heatmap.}

\item{right_hm}{See ?similarity_matrix_heatmap.}

\item{top_hm}{See ?similarity_matrix_heatmap.}

\item{bottom_hm}{See ?similarity_matrix_heatmap.}

\item{annotation_colours}{See ?similarity_matrix_heatmap.}

\item{min_colour}{See ?similarity_matrix_heatmap.}

\item{max_colour}{See ?similarity_matrix_heatmap.}

\item{...}{Arguments passed to \code{ComplexHeatmap::Heatmap()}.}
}
\value{
Heatmap (class "Heatmap" from ComplexHeatmap) object showing the
distribution of observation co-clustering across resampled data.
}
\description{
Create a heatmap that shows the distribution of observation co-clustering
across resampled data.
}
\examples{
\donttest{
    my_dl <- data_list(
        list(subc_v, "subcortical_volume", "neuroimaging", "continuous"),
        list(income, "household_income", "demographics", "continuous"),
        list(pubertal, "pubertal_status", "demographics", "continuous"),
        uid = "unique_id"
    )
    
    sc <- snf_config(my_dl, n_solutions = 5, max_k = 40)
    
    sol_df <- batch_snf(my_dl, sc)
    
    my_dl_subsamples <- subsample_dl(
        my_dl,
        n_subsamples = 20,
        subsample_fraction = 0.85
    )
    
    batch_subsample_results <- batch_snf_subsamples(
        my_dl_subsamples,
        sc
    )
    
    coclustering_results <- calculate_coclustering(
        batch_subsample_results, 
        sol_df,
        verbose = TRUE
    )
    
    cocluster_dfs <- coclustering_results$"cocluster_dfs"
    
    cocluster_heatmap(
        cocluster_dfs[[1]],
        dl = my_dl,
        top_hm = list(
            "Income" = "household_income",
            "Pubertal Status" = "pubertal_status"
        ),
        annotation_colours = list(
            "Pubertal Status" = colour_scale(
                c(1, 4),
                min_colour = "black",
                max_colour = "purple"
            ),
            "Income" = colour_scale(
                c(0, 4),
                min_colour = "black",
                max_colour = "red"
            )
        )
    )
}
}
