% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mantel_test.R
\name{mantel_test}
\alias{mantel_test}
\title{Mantel test
\loadmathjax}
\usage{
mantel_test(mat1, mat2, nboot = 1000, plot = FALSE)
}
\arguments{
\item{mat1, mat2}{A correlation matrix or an object of class \code{dist}.}

\item{nboot}{The number of permutations to be used. Defaults to \code{1000}.}

\item{plot}{if \code{plot = TRUE}, plots the density estimate of the
permutation distribution along with the observed Z-score as a vertical
line.}
}
\value{
\itemize{
\item \code{mantel_r} The correlation between the two matrices.
\item \code{z_score} The Z-score.
\item \code{p-value} The quantile of the observed Z-score. in the permutation
distribution.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Performs a Mantel test between two correlation/distance matrices. The
function calculates the correlation between two matrices, the Z-score that is
is the sum of the products of the corresponding elements of the matrices and
a two-tailed p-value (null hypothesis: \mjsdeqn{r = 0}).
}
\examples{
\donttest{
library(metan)
# Test if the correlation of traits (data_ge2 dataset)
# changes between A1 and A2 levels of factor ENV
A1 <- corr_coef(data_ge2 \%>\% subset(ENV == "A1"))[["cor"]]
A2 <- corr_coef(data_ge2 \%>\% subset(ENV == "A2"))[["cor"]]
mantel_test(A1, A2, plot = TRUE)

}
}
\seealso{
\code{\link[=pairs_mantel]{pairs_mantel()}}
}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
