% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minimaandpaths.R
\name{feprof.minima}
\alias{feprof.minima}
\title{Calculate free energy profile for minima object}
\usage{
\method{feprof}{minima}(minims, imax = NULL)
}
\arguments{
\item{minims}{minima object.}

\item{imax}{index of a hill from which summation stops (default the rest of hills).}
}
\description{
`feprof.minima` calculates free energy profiles for free energy minima. It finds the global minimum
at the `imax` and calculates the evolution of free energies of a local vs. the global free energy
minimum. The free energy of the global minimum is constant (zero).
}
\examples{
tfes<-fes(acealanme, imax=5000)
minima<-fesminima(tfes)
prof<-feprof(minima)
prof
}
