% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors.R
\name{measrprior}
\alias{measrprior}
\alias{prior}
\alias{prior_}
\alias{prior_string}
\title{Prior definitions for \strong{measr} models}
\usage{
measrprior(
  prior,
  class = c("intercept", "maineffect", "interaction", "slip", "guess"),
  coef = NA,
  lb = NA,
  ub = NA
)

prior(prior, ...)

prior_(prior, ...)

prior_string(prior, ...)
}
\arguments{
\item{prior}{A character string defining a distribution in \strong{Stan} language.
A list of all distributions supported by \strong{Stan} can be found in \emph{Stan
Language Functions Reference} at
\url{https://mc-stan.org/users/documentation/}.}

\item{class}{The parameter class. Defaults to \code{"intercept"}. Must be one of
\code{"intercept"}, \code{"maineffect"}, \code{"interaction"} for the LCDM, or one of
\code{"slip"} or \code{"guess"} for DINA or DINO models.}

\item{coef}{Name of a specific parameter within the defined class. If not
defined, the prior is applied to all parameters within the class.}

\item{lb}{Lower bound for parameter restriction. Defaults to no restriction.}

\item{ub}{Upper bound for parameter restriction. Defaults to no restriction.}

\item{...}{Additional arguments passed to \code{measrprior()}.}
}
\value{
A \link[tibble:tibble-package]{tibble} of class \code{measrprior}.
}
\description{
Create prior definitions for classes of parameters, or specific parameters.
}
\section{Functions}{
\itemize{
\item \code{prior()}: Alias of \code{measrprior()} which allows arguments to be
specified as expressions without quotation marks.

\item \code{prior_()}: Alias of \code{measrprior()} which allows arguments to be
specified as one-sided formulas or wrapped in \code{\link[base:substitute]{base::quote()}}.

\item \code{prior_string()}: Alias of \code{measrprior()} which allows arguments to be
specified as character strings.

}}
\examples{
# Use alias functions to define priors without quotes, as formulas,
# or as character strings.
(prior1 <- prior(lognormal(0, 1), class = maineffect))
(prior2 <- prior_(~lognormal(0, 1), class = ~maineffect))
(prior3 <- prior_string("lognormal(0, 1)", class = "maineffect"))
identical(prior1, prior2)
identical(prior1, prior3)
identical(prior2, prior3)
}
