% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{setrowtype}
\alias{setrowtype}
\title{Sets row type for a matrix or a list of matrices}
\usage{
setrowtype(a, rowtype)
}
\arguments{
\item{a}{the matrix on which row type is to be set}

\item{rowtype}{the type of item stored in rows}
}
\value{
\code{a} with rowtype attribute set to \code{rowtype}.
}
\description{
This function is a wrapper for \code{attr} so that 
setting can be accomplished by the pipe operator (\code{\%>\%}).
Row types are strings stored in the \code{rowtype} attribute.
}
\details{
If \code{is.null(rowtype)}, the rowtype attribute is deleted
and subsequent calls to \code{rowtype} will return \code{NULL}.
}
\examples{
library(dplyr)
commoditynames <- c("c1", "c2")
industrynames <- c("i1", "i2")
U <- matrix(1:4, ncol = 2, dimnames = list(commoditynames, industrynames))
U \%>\% setrowtype("Commodities")
# This also works for lists
setrowtype(list(U,U), rowtype = "Commodities")
setrowtype(list(U,U), rowtype = list("Commodities", "Commodities"))
DF <- data.frame(U = I(list()))
DF[[1,"U"]] <- U
DF[[2,"U"]] <- U
setrowtype(DF$U, "Commodities")
DF <- DF \%>\% mutate(newcol = setrowtype(U, "Commodities"))
DF$newcol[[1]]
DF$newcol[[2]]
}
