% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{select_rows_byname}
\alias{select_rows_byname}
\title{Select rows of a matrix (or list of matrices) by name}
\usage{
select_rows_byname(a, retain_pattern = "$^", remove_pattern = "$^")
}
\arguments{
\item{a}{a matrix or a list of matrices}

\item{retain_pattern}{an extended regex or list of extended regular expressions that specifies which rows of \code{m} to retain.
Default pattern (\code{$^}) retains nothing.}

\item{remove_pattern}{an extended regex or list of extended regular expressions that specifies which rows of \code{m} to remove
Default pattern (\code{$^}) removes nothing.}
}
\value{
a matrix that is a subset of \code{m} with rows selected by \code{retain_pattern} and \code{remove_pattern}.
}
\description{
Arguments indicate which rows are to be retained and which are to be removed.
For maximum flexibility, arguments are extended regex patterns
that are matched against row names.
}
\details{
If \code{a} is \code{NULL}, \code{NULL} is returned.

Patterns are compared against row names using extended regex.
If no row names of \code{m} match the \code{retain_pattern}, \code{NULL} is returned.
If no row names of \code{m} match the \code{remove_pattern}, \code{m} is returned.
Note that the default \code{retain_pattern} and \code{remove_pattern} (\code{$^}) 
retain nothing and remove nothing.

Retaining rows takes precedence over removing rows, always.

Some typical patterns are:
\itemize{
  \item{\code{^Electricity$|^Oil$}: row names that are EXACTLY \code{Electricity} or EXACTLY \code{Oil}.}
  \item{\code{^Electricity|^Oil}: row names that START WITH \code{Electricity} or START WITH \code{Oil}.}
  \item{\code{Electricity|Oil}: row names that CONTAIN \code{Electricity} or CONTAIN \code{Oil} anywhere within them.}
}

Given a list of row names, a pattern can be constructed easily using the \code{make_pattern} function.
\code{\link{make_pattern}} escapes regex strings using \code{\link[Hmisc]{escapeRegex}}.
This function assumes that \code{retain_pattern} and \code{remove_pattern} have already been
suitably escaped.
}
\examples{
m <- matrix(1:16, ncol = 4, dimnames=list(c(paste0("i", 1:4)), paste0("p", 1:4))) \%>\%
  setrowtype("Industries") \%>\% setcoltype("Commodities")
select_rows_byname(m, retain_pattern = make_pattern(c("i1", "i4"), pattern_type = "exact"))
select_rows_byname(m, remove_pattern = make_pattern(c("i1", "i3"), pattern_type = "exact"))
# Also works for lists and data frames
select_rows_byname(list(m,m), retain_pattern = "^i1$|^i4$")
}
