% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/response_list.R
\name{response_list}
\alias{response_list}
\alias{response_list.matriks}
\title{Response list (Method)}
\usage{
response_list(obj, seed, ...)

\method{response_list}{matriks}(obj, seed = 666, ...)
}
\arguments{
\item{obj}{matriks, The matriks for which the distractor is generated}

\item{seed}{seed}

\item{...}{other arguments}
}
\value{
An object of class responses of length 11, containing the correct response + 10 distractors (3 repetition, 1 difference, 2 wrong principles, 4 incomplete correlate)

An object of class responses of length 11, containing the correct response + 10 distractors (3 repetition, 1 difference, 2 wrong principles, 4 incomplete correlate)
}
\description{
Generate the response list from a matriks (correct response and distractors)
}
\section{Methods (by class)}{
\itemize{
\item \code{response_list(matriks)}: Response list

Generate the response list from a matriks (correct response and distractors)

}}
\examples{
# create a matrix
m1 <- mat_apply(hexagon(), hrules = "lty", vrules = "size")
# draw the matrix
draw(m1)
# draw the responses
draw(response_list(m1))

# change the difference distractor by changing the random seed
draw(response_list(m1, seed = 8))
# create a matrix
m1 <- mat_apply(hexagon(), hrules = "lty", vrules = "size")
# draw the matrix
draw(m1)
# draw the responses
draw(response_list(m1))

# change the difference distractors by changing the random seed
draw(response_list(m1, seed = 8))
}
