% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mts.R
\name{mts_list_sources}
\alias{mts_list_sources}
\title{List tileset sources in your Mapbox account}
\usage{
mts_list_sources(
  username,
  sortby = c("created", "modified"),
  limit = 100,
  start = NULL,
  access_token = NULL
)
}
\arguments{
\item{username}{Your Mapbox username}

\item{sortby}{One of \code{"created"} or \code{"modified"}; the returned data frame will be sorted by one of these two options.}

\item{limit}{The number of tileset sources to return; defaults to 100.  The maximum number of tileset sources returned by this endpoint is 2000.}

\item{start}{The source ID at which to start the list of sources; defaults to \code{NULL}.}

\item{access_token}{Your Mapbox access token with secret scope.}
}
\value{
A data frame containing information on your tileset sources.
}
\description{
List tileset sources in your Mapbox account
}
\examples{
\dontrun{
source_list <- mts_list_sources(username = "your_mapbox_username")
}
}
\seealso{
\url{https://docs.mapbox.com/api/maps/mapbox-tiling-service/#create-a-tileset-source}
}
