#' @title Print 'all_paths' Class Object
#'
#' @description Print the content of 'all_paths'-class object,
#' which can be generated by [all_indirect_paths()].
#'
#' @details This function is used to
#' print the paths identified in a readable
#' format.
#'
#' @return
#'  `x` is returned invisibly. Called for its side effect.
#'
#' @param x A 'all_paths'-class object.
#' @param ...  Optional arguments.
#'
#' @author Shu Fai Cheung <https://orcid.org/0000-0002-9871-9448>
#'
#' @seealso [all_indirect_paths()]
#'
#' @examples
#' library(lavaan)
#' data(data_serial_parallel)
#' mod <-
#' "
#' m11 ~ x + c1 + c2
#' m12 ~ m11 + x + c1 + c2
#' m2 ~ x + c1 + c2
#' y ~ m12 + m2 + m11 + x + c1 + c2
#' "
#' fit <- sem(mod, data_serial_parallel,
#'            fixed.x = FALSE)
#' # All indirect paths
#' out1 <- all_indirect_paths(fit)
#' out1
#'
#' @export

print.all_paths <- function(x, ...) {
  path_chr <- names(x)
  out <- data.frame(path = path_chr)
  call0 <- attr(x, "call")
  cat("Call:", "\n")
  print(call0)
  if (isTRUE(length(x) == 0)) {
      cat("No indirect paths were found.\n")
    } else {
      cat("Path(s):", "\n")
      print(out, right = FALSE)
    }
  invisible(x)
}