% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01-utils.R
\docType{data}
\name{valueType_list}
\alias{valueType_list}
\title{Built-in data frame of allowed valueType values}
\format{
\subsection{\code{data.frame}}{

A data frame with 12 rows and 7 columns:
\describe{
\item{valueType}{data type as described in Opal}
\item{typeof}{data type provided by base::typeof}
\item{class}{data class provided by base::class}
\item{call}{function to transpose object according base::do.call function}
\item{toValueType}{ensemble data type as described in Opal}
\item{toTypeof}{ensemble data type provided by base::typeof}
\item{genericType}{ensemble data type which valueType belongs}
...
}
}
}
\usage{
valueType_list
}
\description{
Provides a built-in data frame showing the list of allowed Opal valueType
values and their corresponding R data types. This data frame is mainly used
for internal processes and programming.
}
\details{
The valueType is a declared property of a variable that is required in
certain functions to determine handling of the variables. Specifically,
valueType refers to the
\href{https://opaldoc.obiba.org/en/dev/variables-data.html#value-types}{OBiBa data type of a variable}.
The valueType is specified in a data dictionary in a column 'valueType' and
can be associated with variables as attributes. Acceptable valueTypes
include 'text', 'integer', 'decimal', 'boolean', datetime', 'date'. The full
list of OBiBa valueType possibilities and their correspondence with R data
types are available using \link{valueType_list}. The valueType can be used to
coerce the variable to the corresponding data type.
}
\examples{
{

print(valueType_list)

}
}
\seealso{
\href{https://opaldoc.obiba.org/en/dev/magma-user-guide/value/type.html}{Opal documentation}
}
\keyword{datasets}
