% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02-dictionaries_functions.R
\name{is_data_dict_mlstr}
\alias{is_data_dict_mlstr}
\title{Test if an object is a valid Maelstrom data dictionary}
\usage{
is_data_dict_mlstr(object)
}
\arguments{
\item{object}{A potential Maelstrom formatted data dictionary to be
evaluated.}
}
\value{
A logical.
}
\description{
Tests if the input object is a valid data dictionary compliant with formats
used in Maelstrom Research ecosystem, including Opal. This function mainly
helps validate input within other functions of the package but could be used
to check if an object is valid for use in a function.
}
\details{
A data dictionary contains metadata about variables and can be associated
with a dataset. It must be a list of data frame-like objects with elements
named 'Variables' (required) and 'Categories' (if any). To be usable in any
function, the 'Variables' element must contain at least the 'name' column,
and the 'Categories' element must contain at least the 'variable' and 'name'
columns. To be considered as a minimum workable data dictionary, in
'Variables' the 'name' column must also have unique and non-null entries,
and in 'Categories' the combination of 'variable' and 'name' columns must
also be unique'.
}
\examples{
{

# use DEMO_files provided by the package

data_dict <- DEMO_files$dd_MELBOURNE_1_format_maelstrom
is_data_dict_mlstr(data_dict)
is_data_dict_mlstr(iris)

}

}
\seealso{
For a better assessment, please use \code{\link[=data_dict_evaluate]{data_dict_evaluate()}}.
}
