% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01-dictionaries_functions.R
\name{data_dict_apply}
\alias{data_dict_apply}
\title{Apply a data dictionary to a dataset}
\usage{
data_dict_apply(dataset, data_dict = NULL)
}
\arguments{
\item{dataset}{A tibble identifying the input dataset observations
associated to its data dictionary.}

\item{data_dict}{A list of tibble(s) representing meta data of an
associated dataset.
Automatically generated if not provided.}
}
\value{
A tibble identifying the dataset with the data dictionary applied to each
variable as attributes.
}
\description{
Applies a data dictionary to a data structure, creating a labelled dataset.
All previous attributes will be preserved. For factors, the attribute
'levels' will be transformed into attribute 'labels' and values will be
recast into appropriate datatypes.
}
\details{
A dataset must be a data frame-like object and can be associated with a
data dictionary. If no data dictionary is provided, a minimum workable
data dictionary will be generated as needed by relevant functions.
An identifier \code{id} column for sorting can be specified by the user. If
specified, the \code{id} values must be non-missing and will be used in functions
that require it. If no identifier column is specified, indexing is handled
automatically by the function.

A data dictionary contains metadata about variables and can be associated
with a dataset. It must be a list of data frame-like objects with elements
named 'Variables' (required) and 'Categories' (if any). To be usable in any
function, the 'Variables' element must contain at least the 'name' column,
and the 'Categories' element must contain at least the 'variable' and 'name'
columns. To be considered as a minimum workable data dictionary, in
'Variables' the 'name' column must also have unique and non-null entries,
and in 'Categories' the combination of 'variable' and 'name' columns must
also be unique'.
}
\examples{
{

# use DEMO_files provided by the package

dataset <- DEMO_files$dataset_MELBOURNE_1
data_dict <- as_data_dict_mlstr(DEMO_files$dd_MELBOURNE_1_format_maelstrom)
data_dict_apply(dataset, data_dict)

}

}
\seealso{
\code{\link[base:attributes]{base::attributes()}}
}
