% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05-unit_checks.R
\name{check_data_dict_categories}
\alias{check_data_dict_categories}
\title{Assess a data dictionary for potential issues in categories}
\usage{
check_data_dict_categories(data_dict)
}
\arguments{
\item{data_dict}{A list of tibble(s) representing meta data to be evaluated.}
}
\value{
A tibble providing categorical variables that has issues within a
data dictionary.
}
\description{
Generates a tibble report of any categorical variable name present in the
'Categories' element but not present in 'Variables'. The tibble also reports
any non-unique combinations of 'variable' and 'name' in the 'Categories'
element.
This report can be used to help assess data structure, presence of fields,
coherence across elements, and taxonomy or data dictionary formats.
}
\details{
A data dictionary contains metadata about variables and can be associated
with a dataset. It must be a list of data frame-like objects with elements
named 'Variables' (required) and 'Categories' (if any). To be usable in any
function, the 'Variables' element must contain at least the 'name' column,
and the 'Categories' element must contain at least the 'variable' and 'name'
columns. To be considered as a minimum workable data dictionary, in
'Variables' the 'name' column must also have unique and non-null entries,
and in 'Categories' the combination of 'variable' and 'name' columns must
also be unique'.
}
\examples{
{

# use DEMO_files provided by the package

data_dict <- DEMO_files$`dd_TOKYO_format_maelstrom_tagged - ERROR`
check_data_dict_categories(data_dict)

}

}
