% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01-dictionaries_functions.R
\name{as_data_dict}
\alias{as_data_dict}
\title{Validate and coerce any object as data dictionary}
\usage{
as_data_dict(object)
}
\arguments{
\item{object}{A potential valid data dictionary to be coerced.}
}
\value{
A list of tibble(s) identifying a data dictionary.
}
\description{
Validates the input object as a valid data dictionary and coerces it with
the appropriate madshapR::class attribute. This function mainly helps
validate input within other functions of the package but could be used to
check if an object is valid for use in a function.
}
\details{
A data dictionary contains metadata about variables and can be associated
with a dataset. It must be a list of data frame-like objects with elements
named 'Variables' (required) and 'Categories' (if any). To be usable in any
function, the 'Variables' element must contain at least the 'name' column,
and the 'Categories' element must contain at least the 'variable' and 'name'
columns. To be considered as a minimum workable data dictionary, in
'Variables' the 'name' column must also have unique and non-null entries,
and in 'Categories' the combination of 'variable' and 'name' columns must
also be unique'.
}
\examples{
{

# use DEMO_files provided by the package

data_dict <- DEMO_files$dd_PARIS_format_maelstrom
as_data_dict(data_dict)

}

}
\seealso{
For a better assessment, please use \code{\link[=data_dict_evaluate]{data_dict_evaluate()}}.
}
