% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.mHMM.R
\name{plot.mHMM}
\alias{plot.mHMM}
\title{Plotting the posterior densities for a fitted multilevel HMM}
\usage{
\method{plot}{mHMM}(
  x,
  component = "gamma",
  dep = 1,
  col,
  dep_lab,
  cat_lab,
  lwd1 = 2,
  lwd2 = 1,
  lty1 = 1,
  lty2 = 3,
  legend_cex,
  burn_in,
  ...
)
}
\arguments{
\item{x}{Object of class \code{mHMM}, generated by the function
\code{\link{mHMM}}.}

\item{component}{String specifying if the displayed posterior densities
should be for the transition probability matrix gamma (\code{component =
"gamma"}), or for the emission distribution probabilities (\code{component
= "emiss"}). In case of the latter and the model is based on multiple
dependent variables, the user has to indicate for which dependent variable
the posterior densities have to be plotted, see \code{dep}.}

\item{dep}{Integer specifying for which dependent variable the posterior
densities should be plotted. Only required if one wishes to plot the
emission distribution probabilities and the model is based on multiple
dependent variables. Defaults to \code{dep = 1}.}

\item{col}{Vector of colors for the posterior density lines. If one is
plotting the posterior densities for gamma, or the posterior densities of
Normally distributed emission probabilities, the vector has length \code{m}
(i.e., number of hidden states). If one is plotting the posterior densities
for categorical emission probabilities, the vector has length
\code{q_emiss[k]} (i.e., the number of outcome categories for the dependent
variable \code{k}).}

\item{dep_lab}{Optional string when plotting the posterior
densities of the emission probabilities with length 1, denoting the label
for the dependent variable plotted. Automatically obtained from the input
object \code{x} when not specified.}

\item{cat_lab}{Optional vector of strings when plotting the posterior
densities of categorical emission probabilities, denoting the labels of the
categorical outcome values. Automatically generated when not provided.}

\item{lwd1}{Positive number indicating the line width of the posterior
density at the group level.}

\item{lwd2}{Positive number indicating the line width of the posterior
density at the subject level.}

\item{lty1}{Positive number indicating the line type of the posterior
density at the group level.}

\item{lty2}{Positive number indicating the line type of the posterior
density at the subject level.}

\item{legend_cex}{A numerical value giving the amount by which plotting text
and symbols in the legend should be magnified relative to the default.}

\item{burn_in}{An integer which specifies the number of iterations to discard
when obtaining the model parameter summary statistics. When left
unspecified, the burn in period specified at creating the \code{mHMM}
object with the function \code{\link{mHMM}} will be used.}

\item{...}{Arguments to be passed to methods (see \code{\link[graphics]{par}})}
}
\value{
\code{plot.mHMM} returns a plot of the posterior densities. Depending
  on whether (\code{component = "gamma"}) or (\code{component = "emiss"}),
  the plotted posterior densities are either for the transition probability
  matrix gamma or for the emission distribution probabilities, respectively.
}
\description{
\code{plot.mHMM} plots the posterior densities for a fitted multilevel hidden
Markov model for the group and subject level parameters simultaneously. The
plotted posterior densities are either for the transition probability matrix
gamma, or for the emission distribution probabilities (categorical data) or
means and standard deviation (continuous data).
}
\details{
Note that the standard deviation of the (variable and) state specific Normal
emission distribution in case of continuous data is fixed over subjects.
Hence, for the standard deviation, only the posterior distribution at the
group level is plotted.
}
\examples{
###### Example on package example data, see ?nonverbal
# First run the function mHMM on example data
\donttest{
# specifying general model properties:
m <- 2
n_dep <- 4
q_emiss <- c(3, 2, 3, 2)

# specifying starting values
start_TM <- diag(.8, m)
start_TM[lower.tri(start_TM) | upper.tri(start_TM)] <- .2
start_EM <- list(matrix(c(0.05, 0.90, 0.05, 0.90, 0.05, 0.05), byrow = TRUE,
                        nrow = m, ncol = q_emiss[1]), # vocalizing patient
                 matrix(c(0.1, 0.9, 0.1, 0.9), byrow = TRUE, nrow = m,
                        ncol = q_emiss[2]), # looking patient
                 matrix(c(0.90, 0.05, 0.05, 0.05, 0.90, 0.05), byrow = TRUE,
                        nrow = m, ncol = q_emiss[3]), # vocalizing therapist
                 matrix(c(0.1, 0.9, 0.1, 0.9), byrow = TRUE, nrow = m,
                        ncol = q_emiss[4])) # looking therapist

# Run a model without covariate(s):
out_2st <- mHMM(s_data = nonverbal, gen = list(m = m, n_dep = n_dep,
                q_emiss = q_emiss), start_val = c(list(start_TM), start_EM),
                mcmc = list(J = 11, burn_in = 5))

## plot the posterior densities for gamma
plot(out_2st, component = "gamma")
}

}
\seealso{
\code{\link{mHMM}} for fitting the multilevel hidden Markov
  model, creating the object \code{mHMM}.
}
