% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lol.R
\name{lol.project.qoq}
\alias{lol.project.qoq}
\title{Quadratic Optimal QDA (QOQ)}
\usage{
lol.project.qoq(X, Y, r, ...)
}
\arguments{
\item{X}{\code{[n, d]} the data with \code{n} samples in \code{d} dimensions.}

\item{Y}{\code{[n]} the labels of the samples with \code{K} unique labels.}

\item{r}{the rank of the projection. Note that \code{r >= K}, and \code{r < d}.}

\item{...}{trailing args.}
}
\value{
A list of class \code{embedding} containing the following:
\item{A}{\code{[d, r]} the projection matrix from \code{d} to \code{r} dimensions.}
\item{ylabs}{\code{[K]} vector containing the \code{K} unique, ordered class labels.}
\item{centroids}{\code{[K, d]} centroid matrix of the \code{K} unique, ordered classes in native \code{d} dimensions.}
\item{priors}{\code{[K]} vector containing the \code{K} prior probabilities for the unique, ordered classes.}
\item{Xr}{\code{[n, r]} the \code{n} data points in reduced dimensionality \code{r}.}
\item{cr}{\code{[K, r]} the \code{K} centroids in reduced dimensionality \code{r}.}
}
\description{
A function for implementing the Quadratic Optimal QDA Projection (QOQ) Algorithm, an intuitive adaptation of the Linear Optimal Low-Rank Projection (LOL).
}
\examples{
library(lolR)
data <- lol.sims.qdtoep(n=200, d=30)  # 200 examples of 30 dimensions
X <- data$X; Y <- data$Y
model <- lol.project.qoq(X=X, Y=Y, r=5)  # use qoq to project into 5 dimensions
}
\author{
Eric Bridgeford
}
