% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LMK_plotting.R
\name{LMK_wireframe}
\alias{LMK_wireframe}
\title{Compare Wireframes}
\usage{
LMK_wireframe(
  A1,
  A2,
  cols = c("red", "blue"),
  links = NULL,
  pts = c("point", "sphere", "none"),
  rad = c(0.001, 0.001),
  vectors = FALSE,
  ...
)
}
\arguments{
\item{A1}{a reference}

\item{A2}{a target}

\item{cols}{a list of two colors to use for plots (default Red, Blue)}

\item{links}{a wireframe listing landmarks to be linked}

\item{pts}{Should landmarks be plotted as points, spheres, or not at all.}

\item{rad}{radius to plot for spheres, default is .001. Unclear how project specific}

\item{vectors}{Should vectors be drawn linking homologous landmarks. This may help show the direction of change, or could look clunky}

\item{...}{Additional arguments to pass to plotting functions.}
}
\description{
Function to plot two landmark configurations as wireframes, and compare directly
}
\details{
Plots two LMK configurations on top of each other as some combination of fixed points and wireframe. Presumably this will be PC min/max, two group means, or mshape and a target individual, but any two matching configurations should work
}
