\name{DT_fulldiallel}
\alias{DT_fulldiallel}
\docType{data}
\title{
Full diallel data for corn hybrids
}
\description{
This dataset contains phenotpic data for 36 winter bean hybrids, coming from a full diallel design and evaluated for 9 traits. The column male and female origin columns are included as well. 

}
\usage{data("DT_fulldiallel")}
\format{
  The format is:
 chr "DT_fulldiallel"
}
\source{
This data was generated by a winter bean study and originally included in the agridat package.
}
\references{

Giovanny Covarrubias-Pazaran (2024).  lme4breeding: enabling genetic evaluation in the age of genomic data. To be submitted to Bioinformatics.

Douglas Bates, Martin Maechler, Ben Bolker, Steve Walker (2015). Fitting Linear Mixed-Effects Models Using lme4. Journal of Statistical Software, 67(1), 1-48.

}
\examples{

data(DT_fulldiallel)
DT <- DT_fulldiallel
head(DT)
mix <- lmebreed(stems~1 + (1|female)+(1|male), data=DT)
vc <- VarCorr(mix); print(vc,comp=c("Variance"))


}
\keyword{datasets}
\seealso{The core function of the package \code{\link{lmebreed}} }
