% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map.feature.R
\name{map.feature}
\alias{map.feature}
\title{Create a map}
\usage{
map.feature(languages, features = "", popup = "", label = "",
  latitude = NULL, longitude = NULL, label.hide = TRUE,
  label.fsize = 14, label.position = "right", label.emphasize = list(NULL,
  "black"), stroke.features = NULL, density.estimation = NULL,
  density.estimation.color = NULL, density.estimation.opacity = 0.6,
  density.points = TRUE, density.longitude.width = NULL,
  density.latitude.width = NULL, density.legend = TRUE,
  density.legend.opacity = 1, density.legend.position = "bottomleft",
  density.title = "", density.control = FALSE, color = NULL,
  stroke.color = NULL, image.url = NULL, image.width = 100,
  image.height = 100, image.X.shift = 0, image.Y.shift = 0,
  title = NULL, stroke.title = NULL, control = FALSE, legend = TRUE,
  legend.opacity = 1, legend.position = "topright", stroke.legend = TRUE,
  stroke.legend.opacity = 1, stroke.legend.position = "bottomleft",
  width = 5, stroke.radius = 9.5, opacity = 1, stroke.opacity = 1,
  scale.bar = TRUE, scale.bar.position = "bottomleft", minimap = FALSE,
  minimap.position = "bottomright", minimap.width = 150,
  minimap.height = 150, tile = "OpenStreetMap.Mapnik", tile.name = NULL,
  zoom.control = FALSE, zoom.level = NULL, rectangle.lng = NULL,
  rectangle.lat = NULL, minichart = NULL, minichart.data = NULL,
  minichart.time = NULL, minichart.labels = FALSE,
  rectangle.color = "black", map.orientation = "Pacific",
  glottolog.source = "modified")
}
\arguments{
\item{languages}{character vector of languages (can be written in lower case)}

\item{features}{character vector of features}

\item{popup}{character vector of strings that will appear in pop-up window}

\item{label}{character vector of strings that will appear near points}

\item{latitude}{numeric vector of latitudes}

\item{longitude}{numeric vector of longitudes}

\item{label.hide}{logical. If FALSE, labels are displayed allways. If TRUE, labels are displayed on mouse over. By default is TRUE.}

\item{label.fsize}{numeric value of the label font size. By default is 14.}

\item{label.position}{the position of labels: "left", "right", "top", "bottom"}

\item{label.emphasize}{is the list. First argument is a vector of points in datframe that should be emphasized. Second argument is a string with a color for emphasis.}

\item{stroke.features}{additional independent stroke features}

\item{density.estimation}{additional independent features, used for density estimation}

\item{density.estimation.color}{vector of density polygons' colors}

\item{density.estimation.opacity}{a numeric vector of density polygons opacity.}

\item{density.points}{logical. If FALSE, it doesn't show points in polygones.}

\item{density.longitude.width}{bandwidths for longitude values. Defaults to normal reference bandwidth (see \link{bandwidth.nrd}).}

\item{density.latitude.width}{bandwidths for latitude values. Defaults to normal reference bandwidth (see \link{bandwidth.nrd}).}

\item{density.legend}{logical. If TRUE, function show legend for density features. By default is FALSE.}

\item{density.legend.opacity}{a numeric vector of density-legend opacity.}

\item{density.legend.position}{the position of the legend: "topright", "bottomright", "bottomleft","topleft"}

\item{density.title}{title of a density-feature legend}

\item{density.control}{logical. If TRUE, function show layer control buttons for density plot. By default is FALSE}

\item{color}{vector of colors or palette. The color argument can be (1) a character vector of RGM or named colors; (2) the name of an RColorBrewer palette; (3) the full name of a viridis palette; (4) a function that receives a single value between 0 and 1 and returns a color. For more examples see \code{\link{colorNumeric}}}

\item{stroke.color}{vector of stroke colors}

\item{image.url}{character vector of URLs with an images}

\item{image.width}{numeric vector of image widths}

\item{image.height}{numeric vector of image heights}

\item{image.X.shift}{numeric vector of image's X axis shift relative to the latitude-longitude point}

\item{image.Y.shift}{numeric vector of image's Y axis shift relative to the latitude-longitude point}

\item{title}{title of a legend.}

\item{stroke.title}{title of a stroke-feature legend.}

\item{control}{logical. If TRUE, function show layer control buttons. By default is FALSE}

\item{legend}{logical. If TRUE, function show legend. By default is FALSE.}

\item{legend.opacity}{a numeric vector of legend opacity.}

\item{legend.position}{the position of the legend: "topright", "bottomright", "bottomleft","topleft"}

\item{stroke.legend}{logical. If TRUE, function show stroke.legend. By default is FALSE.}

\item{stroke.legend.opacity}{a numeric vector of stroke.legend opacity.}

\item{stroke.legend.position}{the position of the stroke.legend: "topright", "bottomright", "bottomleft","topleft"}

\item{width}{a numeric vector of radius for circles or width for barcharts in minicharts.}

\item{stroke.radius}{a numeric vector of stroke radii for the circles.}

\item{opacity}{a numeric vector of marker opacity.}

\item{stroke.opacity}{a numeric vector of stroke opacity.}

\item{scale.bar}{logical. If TRUE, function shows scale-bar. By default is TRUE.}

\item{scale.bar.position}{the position of the scale-bar: "topright", "bottomright", "bottomleft","topleft"}

\item{minimap}{logical. If TRUE, function shows mini map. By default is FALSE.}

\item{minimap.position}{the position of the minimap: "topright", "bottomright", "bottomleft","topleft"}

\item{minimap.width}{The width of the minimap in pixels.}

\item{minimap.height}{The height of the minimap in pixels.}

\item{tile}{a character verctor with a map tiles, popularized by Google Maps. See \href{https://leaflet-extras.github.io/leaflet-providers/preview/index.html}{here} for the complete set.}

\item{tile.name}{a character verctor with a user's map tiles' names.}

\item{zoom.control}{logical. If TRUE, function shows zoom controls. By default is FALSE.}

\item{zoom.level}{a numeric value of the zoom level.}

\item{rectangle.lng}{vector of two longitude values for rectangle.}

\item{rectangle.lat}{vector of two latitude values for rectangle.}

\item{minichart}{citation from leaflet.minicharts package: "Possible values are "bar" for bar charts, "pie" for pie charts, "polar-area" and "polar-radius"."}

\item{minichart.data}{citation from leaflet.minicharts package: "A numeric matrix with number of rows equal to the number of elements in lng or lat and number of column equal to the number of variables to represent. If parameter time is set, the number of rows must be equal to the length of lng times the number of unique time steps in the data."}

\item{minichart.time}{citation from leaflet.minicharts package: "A vector with length equal to the number of rows in chartdata and containing either numbers representing time indices or dates or datetimes. Each unique value must appear as many times as the others. This parameter can be used when one wants to represent the evolution of some variables on a map."}

\item{minichart.labels}{citation from leaflet.minicharts package: "Should values be displayed above chart elements."}

\item{rectangle.color}{vector of rectangle border color.}

\item{map.orientation}{a character verctor with values "Pacific" and "Atlantic". It distinguishes Pacific-centered and Atlantic-centered maps. By default is "Pacific".}

\item{glottolog.source}{A character vector that define which glottolog database is used: "original" or "modified" (by default)}
}
\description{
Map a set of languages and color them by feature or two sets of features.
}
\examples{
map.feature(c("Adyghe", "Russian"))

## Map all Slavic languages
map.feature(lang.aff(c("Slavic")))

## Color languages by feature
df <- data.frame(lang = c("Adyghe", "Kabardian", "Polish", "Russian", "Bulgarian"),
feature = c("polysynthetic", "polysynthetic", "fusion", "fusion", "fusion"))
map.feature(df$lang, df$feature)

## Add your own coordinates
map.feature("Adyghe", latitude = 43, longitude = 57)

## Change map tile
map.feature("Adyghe", tile = "Thunderforest.OpenCycleMap")

## Add you own colors
df <- data.frame(lang = c("Adyghe", "Kabardian", "Polish", "Russian", "Bulgarian"),
feature = c("polysynthetic", "polysynthetic", "fusion", "fusion", "fusion"),
popup = c("Circassian", "Circassian", "Slavic", "Slavic", "Slavic"))
map.feature(df$lang, df$feature, df$popup, color = c("green", "navy"))

## Map two sets of features
df <- data.frame(lang = c("Adyghe", "Kabardian", "Polish", "Russian", "Bulgarian"),
feature = c("polysynthetic", "polysynthetic", "fusion", "fusion", "fusion"),
popup = c("Circassian", "Circassian", "Slavic", "Slavic", "Slavic"))
map.feature(df$lang, df$feature, df$popup,
stroke.features = df$popup)

## Add a minimap to plot
map.feature(c("Adyghe", "Russian"), minimap = TRUE)

## Remove scale bar
map.feature(c("Adyghe", "Russian"), scale.bar = FALSE)

}
\author{
George Moroz <agricolamz@gmail.com>
}
