% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lyl_summary.R
\name{summary.lyl_range}
\alias{summary.lyl_range}
\title{Summarize Life Years Lost over a range of differents ages}
\usage{
\method{summary}{lyl_range}(object, decimals = 2, weights = NA, difference = FALSE, ...)
}
\arguments{
\item{object}{An object of class \code{lyl_range} (obtained with function \code{lyl_range}).}

\item{decimals}{Number of decimals to be reported (default is 2).}

\item{weights}{Vector with age distribution of disease/condition onset. If weights are not provided (dafault is \code{weights = NA}),
then the differences in Life Years Lost at each age are summarized. If weights are provided, then a weighted average is provided.}

\item{difference}{Parameter automatically created by the package.}

\item{...}{Additional arguments affecting the summary produced.}
}
\value{
A table with the summary of the results.
}
\description{
\code{summary} for objects of class \code{lyl_range} summarizes Life Years Lost
over a range of different ages.
}
\examples{
# Load simulated data as example
data(simu_data)

\donttest{
# Estimate remaining life expectancy and Life Years
# Lost after each age from 0 to 94 years and before age 95 years
lyl_estimation <- lyl_range(data = simu_data, t = age_death, status = death,
                            age_begin = 0, age_end = 94, tau = 95)

# Visualize data at each different specific age
summary(lyl_estimation)

# Summarize data over an age distribution
summary(lyl_estimation, weights = simu_data$age_disease)
}
}
\references{
\itemize{
    \item{Plana-Ripoll et al. lillies – An R package for the estimation of excess Life Years Lost among patients with a given disease or condition.
    \emph{PLoS ONE}. 2020;15(3):e0228073.}
}
}
\seealso{
\itemize{
    \item{\code{\link{lyl_range}} for estimation of Life Years Lost for a range of different ages.}
}
}
