% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdfdataframe.R
\name{as.pdf.data.frame}
\alias{as.pdf.data.frame}
\title{Coerce to PDF from Data Frame}
\usage{
\method{as.pdf}{data.frame}(x, rules = c(2, 1, 1), walls = 0,
  grid = FALSE, rowgroups = factor(rownames(x)),
  colgroups = factor(names(x)), rowbreaks = if (grid) breaks(rowgroups) else
  0, colbreaks = if (grid) breaks(colgroups) else 0, rowgrouprule = 0,
  colgrouprule = 0, rowcolors = NULL, rowgrouplabel = " ",
  charjust = "left", numjust = "right", justify = ifelse(sapply(x,
  is.numeric), numjust, charjust), colwidth = NA, paralign = "top",
  na = "", verbatim = ifelse(sapply(x, is.numeric), TRUE, FALSE),
  escape = "#", trim = TRUE, source = NULL, file = NULL,
  source.label = "source: ", file.label = "file: ", basefile = FALSE,
  tabularEnvironment = "tabular", footnote.size = "tiny", geoLeft = "1mm",
  geoRight = "1mm", geoTop = "1mm", geoBottom = "1mm", wide = NULL,
  long = NULL, wider = 0, longer = 0,
  thispagestyle = command("thispagestyle", args = "empty"),
  pagestyle = command("pagestyle", args = "empty"), prolog = NULL,
  epilog = NULL, stem = "latexpdf-doc", dir = ".", clean = TRUE, ...)
}
\arguments{
\item{x}{data.frame}

\item{rules}{numeric; will be recycled to length 3.  indicates number of horizontal lines above and below the header, and below the last row.}

\item{walls}{numeric, recycled to length 2.  Number of vertical lines on left and right of table.}

\item{grid}{logical, whether to have lines between rows and columns}

\item{rowgroups}{a vector as long as nrow(x), non-repeats trigger horizontal lines}

\item{colgroups}{a vector as long as names(x), non-repeats trigger vertical lines}

\item{rowbreaks}{numeric: a manual way to specify numbers of lines between rows (ignores grid and rowgroups)}

\item{colbreaks}{numeric: a manual way to specify numbers of lines between columns (ignores grid and colgroups)}

\item{rowgrouprule}{number of lines to set off row group column, if rowgroups supplied as character}

\item{colgrouprule}{number of lines to set off col group header, if colgroups supplied as character}

\item{rowcolors}{character vector of color names, recycled as necessary to color all rows (NULL: no color); not compatible with rowgroups}

\item{rowgrouplabel}{character string (at least one character) to label rowgroup column}

\item{charjust}{default justification for character columns}

\item{numjust}{default justification for numeric columns}

\item{justify}{manual specification of column justifications: left, right, center, or decimal (vector as long as ncol(x))}

\item{colwidth}{manual specification of column width. (vector of length ncol(x).) Overrides \code{justify where not NA.}}

\item{paralign}{used with colwidth to align paragraphs: top, middle, or bottom.}

\item{na}{string to replace NA elements}

\item{verbatim}{whether to use verbatim environment for numeric fields.  Makes sense for decimal justification; interacts with \code{trim} and \code{justify}.}

\item{escape}{symbol used by `verb' command as delimiter.  A warning is issued if it is found in non-NA text.}

\item{trim}{passed to the format command: true by default, so that alignment is the responsibility of just the tabular environment arguments}

\item{source}{optional source attribution}

\item{file}{optional file name}

\item{source.label}{optional text to preceed source if specified}

\item{file.label}{optional text to preceed file if specified}

\item{basefile}{if TRUE, strip path from file for display purposes}

\item{tabularEnvironment}{default \code{tabular}; consider also \code{longtable}}

\item{footnote.size}{font size for source and file attributions}

\item{geoLeft}{geometry package: left margin}

\item{geoRight}{geometry package: right margin}

\item{geoTop}{geometry package: top margin}

\item{geoBottom}{geometry package: bottom margin}

\item{wide}{nominal page width in mm}

\item{long}{nominal page length in mm}

\item{wider}{additional page width in mm}

\item{longer}{additional page lenth in mm}

\item{thispagestyle}{thispagestyle command}

\item{pagestyle}{pagestyle command}

\item{prolog}{latex markup to include before x}

\item{epilog}{latex markup to include after x}

\item{stem}{the stem of a file name (no extension)}

\item{dir}{output directory}

\item{clean}{whether to delete system files after pdf creation}

\item{...}{passed eventually to \code{\link{makePreamble}}}
}
\description{
Coerces data.frame to document and then to pdf. Extra arguments are passed to \code{\link{makePreamble}}.  \code{\link{as.document.data.frame}} will try to guess an appropriate width and length( \code{wide}, \code{long}) for the page, but you may need something \code{wider} or \code{longer}, especially if you adjust aesthetics.  Negative values for \code{wider} and \code{longer} are meaningful.
}
\examples{
\dontrun{as.pdf(head(Theoph))}
}
\seealso{
\code{\link{as.pdf.character}}

\code{\link{as.pdf.document}}

\code{\link{as.document.data.frame}}

\code{\link{as.tabular.data.frame}}
}
