#define __MODEL_C__

#include <string.h>
#include <R_ext/Rdynload.h>

#include "model.h"
/*  option_list is the master list of option names and corresponding 
    C functions.  Each option name should be paired with a function 
    that takes 5 arguments:  The first is an int giving the number
    of edge toggles; the second and third are arrays of Vertex and 
    give the actual heads and tails of the edge toggles; the fourth 
    is a ptr to struct OptionInput, which both communicates the inputs 
    to the function and points to the output generated by the function;
    and the fifth is a Gptr containing references to the graph structure.
*/

/* Commented 12/15/03 by CTB */
/* struct ModelOption option_list[] = {   */
/*   {"absdiff", d_absdiff}, */
/*   {"bounded.kstar", d_boundedkstar}, */
/*   {"bounded.triangle",d_boundedtriangle}, */
/*   {"ctriad", d_ctriad}, */
/*   {"degree", d_degree}, */
/*   {"dyadcov", d_dyadcov}, */
/*   {"edgecov", d_edgecov}, */
/*   {"edges", d_edges},   */
/*   {"idegree", d_idegree}, */
/*   {"istar", d_istar}, */
/*   {"kstar", d_kstar}, */
/*   {"nodematch", d_nodematch}, */
/*   {"mutual", d_mutual}, */
/*   {"nodemain", d_nodemain}, */
/*   {"nodefactor", d_nodefactor}, */
/*   {"odegree", d_odegree}, */
/*   {"ostar", d_ostar}, */
/*   {"smalldiff", d_smalldiff}, */
/*   {"latent", d_mutual}, */
/*   {"latentcluster", d_mutual}, */
/*   {"triangle", d_triangle}, */
/*   {"ttriad", d_ttriad}, */
/* #include "userchangeStatsDeclare.h" */
/*  */
/* }; */

/*  ***************** */
/*  void ModelDestroy */
/*  */
void ModelDestroy()
{
  free(change_statistics);
}

/*  ***************** */
/*  int ModelInitialize */
/*  */
/*  Allocate and initialize the OptionInput structures, each of which contains */
/*  all necessary information about how to compute one term in the model. */
/*  ***************** */

int ModelInitialize (char *funnames, char *sonames, double *inputs) {
  int i, j, k, offset;
  struct OptionInput *in;
  char *fn,*sn;
  
/* total_options is a global variable equal to the total number of available */
/*      options, as determined by the definition of the option_list array  */
/*   total_options = sizeof(option_list) / sizeof(struct ModelOption); */
  
  /* selected_options, an array of struct OptionInput with global scope,
     contains one element for each model option.  The in variable is used
     only for bookkeeping purposes within this function. */

  in = selected_options = (struct OptionInput *) malloc(sizeof(struct OptionInput) * n_options);

  n_param = 0;
  while (in < selected_options + n_options) 
    { 
      /* loop through once for each option chosen */
      /* funnames points to a single character string, consisting of the names
      of the selected options concatenated together and separated by spaces.
      This is passed by the calling R function.  These names are matched with
      their respective C functions that calculate the appropriate statistics. 
      Similarly, sonames points to a character string containing the names
      of the shared object files associated with the respective functions.*/
      for (; *funnames == ' ' || *funnames == 0; funnames++);
      for (i = 0; funnames[i] != ' ' && funnames[i] != 0; i++);
      if (funnames[i] == 0 && in-selected_options < n_options-1) 
	{
	  Rprintf("Error in ModelInitialize:  Too few options named.\n");
	  return 0;
	}
      for (; *sonames == ' ' || *sonames == 0; sonames++);
      for (j = 0; sonames[j] != ' ' && sonames[j] != 0; j++);
      if (sonames[j] == 0 && in-selected_options < n_options-1) 
	{
	  Rprintf("Error in ModelInitialize:  Too few options named.\n");
	  return 0;
	}
      
     funnames[i] = 0;
     sonames[j] = 0;
      
/*       for(j = 0; j < total_options && strncmp(option_list[j].name, names, i); j++); */
/*        */
 /*  Above is a very unsophisticated search to match character strings with */
/* 	  their corresponding function pointers.  It's only done once for each  */
/* 	  option, so it doesn't have to be efficient.  */
/*        */
/*       if (j == total_options)  */
/* 	{ */
/* 	  Rprintf("Error in ModelInitialize:  Unrecognized option %s\n", names); */
/* 	  return 0; */
/* 	} */
      /*Extract the required string information from the relevent sources*/
      if((fn=(char *)malloc(sizeof(char)*(i+3)))==NULL){
        Rprintf("Error in ModelInitialize: Could not allocate %d bytes for fn.\n", sizeof(char)*(i+3));
	exit(0);
      }
      fn[0]='d';
      fn[1]='_';
      for(k=0;k<i;k++)
        fn[k+2]=funnames[k];
      fn[i+2]='\0';
      if((sn=(char *)malloc(sizeof(char)*(j+1)))==NULL){
        Rprintf("Error in ModelInitialize: Could not allocate %d bytes for sn.\n", sizeof(char)*(j+1));
	exit(0);
      }
      /* Rprintf("Remaining funnames:%s\nRemaining sonames:%s\n",funnames,sonames); */
      sn=strncpy(sn,sonames,j);
      sn[j]='\0';
      
      /*  Most important part of the struct ModelOption:  A pointer to a
      function that will compute the change in the graph statistic of 
      interest for a particular edge toggle.  This function is obtained by
      searching for symbols associated with the object file with prefix
      sn, having the name fn.  Assuming that one is found, we're golden.*/ 
/*       in->func=option_list[j].func;  */
      in->func=(void (*)(int, Vertex*, Vertex*, struct OptionInput*, Gptr))R_FindSymbol(fn,sn,NULL);
      if(in->func==NULL){
        Rprintf("Error in ModelInitialize: could not find function %s in namespace for package %s.\n",fn,sn);
	exit(0);
      }      

      /*Clean up by freeing sn and fn*/
      free((void *)fn);
      free((void *)sn);

      /*   Now process the values in model$option[[optionnumber]]$inputs; */
      /*   See comments in InitErgmm.r for details.     */
      offset = (int) *inputs++;  /*  Set offset for attr vector */
      in->nstats = (int) *inputs++; /*  Set number of statistics returned */
      if (in->nstats <= 0)
	{ /* Must return at least one statistic */
	  Rprintf("Error in ModelInitialize:  Option %s cannot return %d \
               statistics.\n", funnames, in->nstats);
	  return 0;
	}
      /*   Update the running total:  n_param is total number of stats  */
      n_param += in->nstats; 
      in->dstats = (double *) malloc(sizeof(double) * in->nstats);
      in->ninputparams = (int) *inputs++; /*  Set number of inputs  */
      in->inputparams = (in->ninputparams ==0) ? 0 : inputs; /*  Ptr to inputs */
      in->attrib = inputs + offset; /*  Ptr to attributes (part of inputs) */
      inputs += in->ninputparams;  /*  Skip to next model option */
      
      /*  The lines above set in->inputparams to point to the needed input
      parameters (or zero if none) and then increments the inputs pointer so
      that it points to the inputs for the next model option for the next pass
      through the loop. */

      /****************************
	  if (in->attrib!=0) 
	    {
	    for (j=0; j<n_nodes; j++)
	      Rprintf(" %f ",in->attrib[j]);
	    Rprintf("\n");
	    }
	  Rprintf("\tin->nstats=%d\n",in->nstats);
	  Rprintf("\tin->ninputparams=%d\n",in->ninputparams);
	  for (j=0; j<in->ninputparams; j++)
	  Rprintf("\t\t%f\n",in->inputparams[j]); 
      *****************************/
      
      funnames += i;
      sonames += j;
      ++in;
    }
  
  /* we track the distance metric parameter a little separately */
  if (g_fDistanceMetric)
    {
      n_param++;
    }

  /*  change_statistics, a global pointer, is just a temporary workspace (see
  globals.h).  It could have been allocated by the R function and passed as an
  argument in the .C call, but I did it this way using the rule of thumb that
  only items that must be communicated from R to C or vice versa should be
  passed in the .C call; the change_statistics variable is used wholly within
  the C functions. */
  
  change_statistics = (double*) malloc(sizeof(double) * n_param);
  for(i=0; i<n_param; i++)
    change_statistics[i] = 0.0;

  return 1;
}


/*  ***************** */
/*  void DegreeBoundInitialize */
/*  ***************** */
void DegreeBoundInitialize(int *attribs, int *maxout, int *maxin, int *minout, 
			   int *minin, int condAllDegExact,  int attriblength)
{
  int i,j;
/*   int *g_attribs, *g_maxout, *g_maxin, *g_minout, *g_minin; */
  /*  init array memory */
  g_attribs = malloc(sizeof(int) * attriblength);
  g_maxout  = malloc(sizeof(int) * attriblength);
  g_maxin   = malloc(sizeof(int) * attriblength);
  g_minout  = malloc(sizeof(int) * attriblength);
  g_minin   = malloc(sizeof(int) * attriblength);

  g_fBoundDegByAttr = 0;

  g_attrcount = condAllDegExact ? 1 : attriblength/n_nodes;
  
  /*  bound by degree by attribute per node */
  if (g_attrcount)
    {
      /*  flag that we have data here */
      g_fBoundDegByAttr = 1;
      
      if (!condAllDegExact)
	{
	  for (i=1; i <= n_nodes; i++)
	    for (j=0; j < g_attrcount; j++)
	      {
		g_attribs[i-1 + j*n_nodes] = attribs[(i - 1 + j*n_nodes)];
		 g_maxout[i-1 + j*n_nodes] =  maxout[(i - 1 + j*n_nodes)];
		  g_maxin[i-1 + j*n_nodes] =   maxin[(i - 1 + j*n_nodes)];
		 g_minout[i-1 + j*n_nodes] =  minout[(i - 1 + j*n_nodes)];
		  g_minin[i-1 + j*n_nodes] =   minin[(i - 1 + j*n_nodes)];
	      }
	}
      else  /*  condAllDegExact == TRUE */
	{
	  /*  all ego columns get values of current in and out degrees; */
	  /*  max and min ego columns for (each of in and out) get same value; */

	  for (i=1;i<=n_nodes;i++)
	    g_maxout[i-1] = g_minout[i-1] = outdegree[i];
	  
	  for (i=1;i<=n_nodes;i++)
	    g_maxin[i-1] = g_minin[i-1] = indegree[i];
	  
	}
      
/*   Rprintf("condAllDegExact is %d,  g_attcount is %d attrib length %d g_fBoundDegByAttr %d\n",condAllDegExact, g_attrcount, attriblength, g_fBoundDegByAttr); */
  
#if 0
      Rprintf("attribute list:\n");
      for (j=0; j < g_attrcount; j++)
	{
	  for (i=1;i<(n_nodes + 1);i++)
	    Rprintf("%d ",g_attribs[i][j]);
	  Rprintf("\n");
	}
      
      Rprintf("\nmaxout:\n");
      for (j=0; j < g_attrcount; j++)
	{
	  for (i=1;i<(n_nodes + 1);i++)
	    Rprintf("%d ",g_maxout[i][j]);
	  Rprintf("\n");
	}
      
      Rprintf("\nmaxin:\n");
      for (j=0; j < g_attrcount; j++)
	{
	  for (i=1;i<(n_nodes + 1);i++)
	    Rprintf("%d ",g_maxin[i][j]);
	  Rprintf("\n");
	}
#endif	
    }
}


/* int GetIndexForAttrValue(int value);  unused and undefined */


#undef __MODEL_C__
