% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/t_test_pairwise.R
\name{t_test_pairwise}
\alias{t_test_pairwise}
\title{t test, pairwise}
\usage{
t_test_pairwise(
  data = NULL,
  iv_name = NULL,
  dv_name = NULL,
  sigfigs = 3,
  mann_whitney = TRUE,
  t_test_stats = FALSE,
  t_test_df_decimals = 1,
  sd = FALSE
)
}
\arguments{
\item{data}{a data object (a data frame or a data.table)}

\item{iv_name}{name of the independent variable}

\item{dv_name}{name of the dependent variable}

\item{sigfigs}{number of significant digits to round to}

\item{mann_whitney}{if \code{TRUE}, Mann-Whitney test results will be
included in the output data.table. If \code{TRUE}, Mann-Whitney
tests will not be performed.}

\item{t_test_stats}{if \code{t_test_stats = TRUE}, t-test statistic
and degrees of freedom will be included in the output data.table.}

\item{t_test_df_decimals}{number of decimals for the degrees of freedom
in t-tests (default = 1)}

\item{sd}{if \code{sd = TRUE}, standard deviations will be
included in the output data.table.}
}
\value{
the output will be a data.table showing results of all
pairwise comparisons between levels of the independent variable.
}
\description{
Conducts a t-test for every possible pairwise comparison
with Bonferroni correction
}
\examples{
t_test_pairwise(data = iris, iv_name = "Species", dv_name = "Sepal.Length")
t_test_pairwise(data = iris, iv_name = "Species",
dv_name = "Sepal.Length", t_test_stats = TRUE, sd = TRUE)
t_test_pairwise(data = iris, iv_name = "Species", dv_name = "Sepal.Length",
mann_whitney = FALSE)
}
