% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GWASdata.r
\docType{methods}
\name{snp_info}
\alias{snp_info}
\alias{snp_info,character-method}
\alias{show,snp_info-method}
\alias{summary,snp_info-method}
\title{An S4 class for an object assigning SNP positions to rs-numbers (for internal use)}
\usage{
snp_info(x, ...)

\S4method{snp_info}{character}(x)

\S4method{show}{snp_info}(object)

\S4method{summary}{snp_info}(object)
}
\arguments{
\item{x}{A \code{character} \code{vector} of SNP rsnumbers for which 
positions will be extracted.}

\item{...}{further arguments can be added.}

\item{object}{An \code{object} of class \code{\link{snp_info}}.}
}
\value{
A \code{data.frame} including the SNP positions with columns
'chromosome', 'position' and 'snp'. SNPs not found in the Ensemble database
will not be listed in the returned \code{snp_info} object, SNPs with multiple
positions  will appear several times.

\code{show} Basic information on \code{\link{snp_info}} object.

\code{summary} Summarized information on \code{\link{snp_info}} object.
}
\description{
An S4 class for an object assigning SNP positions to rs-numbers (for internal use)

This function gives for a \code{vector} of SNP identifiers the position of each SNP 
as extracted from the Ensemble database. The database is accessed via the
R-package \pkg{biomaRt}.

\code{show} Shows basic information on \code{\link{snp_info}} object

\code{summary} Summarizes information on \code{\link{snp_info}} object
}
\section{Slots}{

\describe{
\item{\code{info}}{A \code{data.frame} including information on SNP positions}
}}

\examples{
# snp_info
data(rs10243170_info) 
snp_info(c("rs234"))

# show
data(rs10243170_info)
rs10243170_info
# summary
data(rs10243170_info)
summary(rs10243170_info)
}
\author{
Stefanie Friedrichs
}
