% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trace.R
\name{pairstrace_jags}
\alias{pairstrace_jags}
\title{Pairs trace plot}
\usage{
pairstrace_jags(
  x,
  p = NULL,
  points = FALSE,
  contour = FALSE,
  lwd = 1,
  alpha = 0.2,
  parmfrow = NULL,
  ...
)
}
\arguments{
\item{x}{Output object returned from \code{jagsUI}}

\item{p}{Optional vector of parameters to subset}

\item{points}{Whether to plot as scatter plots instead.  Defaults to \code{FALSE}.}

\item{contour}{Whether to plot as contour plots instead.  Defaults to \code{FALSE}.}

\item{lwd}{Line width for trace plots.  Defaults to 1.}

\item{alpha}{Opacity of lines (or points, when \code{points=TRUE}).  Defaults to 0.2.}

\item{parmfrow}{Optional call to \code{par(mfrow)} for the number of rows & columns of plot window.  Returns the graphics device to previous state afterward.}

\item{...}{additional plotting arguments or arguments to \code{tracedens_jags()}}
}
\value{
\code{NULL}
}
\description{
Two-dimensional trace plots (or alternately, scatter plots or contour plots) of each possible pair of
parameters from a possible subset.  May be useful in assessing correlation between parameter nodes, or problematic
posterior surfaces.
}
\examples{
pairstrace_jags(SS_out, p="sig", parmfrow=c(2,3), lwd=2)
pairstrace_jags(SS_out, p="sig", parmfrow=c(2,3), points=TRUE)
pairstrace_jags(SS_out, p="sig", parmfrow=c(2,3), contour=TRUE)

pairstrace_jags(asdf_jags_out, parmfrow=c(3,3))
pairstrace_jags(asdf_jags_out, parmfrow=c(3,3), points=TRUE)
pairstrace_jags(asdf_jags_out, parmfrow=c(3,3), contour=TRUE)
}
\seealso{
\link{tracedens_jags}, \link{crossplot}
}
\author{
Matt Tyers
}
