% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/ternary_labels.R
\docType{methods}
\name{ternary_labels}
\alias{ternary_labels}
\alias{ternary_labels-method}
\alias{ternary_labels,numeric,numeric,numeric-method}
\alias{ternary_labels,ANY,missing,missing-method}
\title{Non-Overlapping Text Labels}
\usage{
ternary_labels(x, y, z, ...)

\S4method{ternary_labels}{numeric,numeric,numeric}(x, y, z, labels = seq_along(x), ...)

\S4method{ternary_labels}{ANY,missing,missing}(x, labels = seq_along(x$x), ...)
}
\arguments{
\item{x, y, z}{A \code{\link{numeric}} vector giving the x, y and z ternary coordinates
of a set of points. If \code{y} and \code{z} are missing, an attempt is made to
interpret \code{x} in a suitable way (see \code{\link[grDevices:xyz.coords]{grDevices::xyz.coords()}}).}

\item{...}{Further graphical parameters (see \code{\link[graphics:par]{graphics::par()}}) may also be
supplied as arguments, particularly, character expansion, \code{cex} and
color, \code{col}.}

\item{labels}{A \code{\link{character}} vector or \code{\link{expression}} specifying the text
to be written.}
}
\value{
\code{ternary_labels()} is called it for its side-effects.
}
\description{
Optimize the location of text labels to minimize overplotting text.
}
\examples{
## Compositional data
coda <- data.frame(
  X = c(41.0, 40, 39.0),
  Y = c(19.5, 20, 20.5),
  Z = c(39.5, 40, 40.5)
)

## Add text
ternary_plot(NULL, panel.first = ternary_grid())
ternary_points(coda)
ternary_labels(coda, labels = c("A", "B", "C"))
}
\seealso{
\code{\link[graphics:text]{graphics::text()}}

Other geometries: 
\code{\link{ternary_arrows}()},
\code{\link{ternary_crosshairs}()},
\code{\link{ternary_lines}()},
\code{\link{ternary_points}()},
\code{\link{ternary_polygon}()},
\code{\link{ternary_segments}()},
\code{\link{ternary_text}()}
}
\author{
N. Frerebeau
}
\concept{geometries}
