% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mediate.R
\name{mediate}
\alias{mediate}
\title{Performing mediation analysis based on the interventional effect}
\usage{
mediate(
  y,
  med,
  treat,
  c = NULL,
  ymodel,
  mmodel,
  treat_lv = 1,
  control_lv = 0,
  incint = NULL,
  inc_mmint = FALSE,
  data,
  sim = 1000,
  conf.level = 0.95,
  complete_analysis = FALSE,
  digits = 2,
  HTML_report = TRUE,
  summary_report = TRUE,
  cores = NULL
)
}
\arguments{
\item{y}{The outcome variable.}

\item{med}{A vector of the mediators.}

\item{treat}{The exposure variable.}

\item{c}{A vector of covariates.}

\item{ymodel}{A character string specifying the outcome model. Current options are "regression" (for continuous variable), "logistic regression" (for binary variable), and "poisson regression" (for count variable)}

\item{mmodel}{A vector of character string specifying the mediator models. Current options are "regression" (for continuous variable), "logistic regression" (for binary variable), and "poisson regression" (for count variable)}

\item{treat_lv}{Value of the treatment variable used as the treatment condition. Default is 1.}

\item{control_lv}{Value of the treatment variable used as the control condition. Default is 0.}

\item{incint}{A vector of boolean specifying if the exposure-mediator interactions are included into the outcome model. Default is NULL.}

\item{inc_mmint}{A boolean value specifying if the mediator-mediator interactions are included. Default is FALSE.}

\item{data}{A data frame containing all the analysis variables.}

\item{sim}{A numerical value specifying the number of simulation. Default is 1000.}

\item{conf.level}{A numerical value specifying the confidence interval the the estimates. Default is 0.95}

\item{complete_analysis}{Multiple imputation will be used to fill in missing value. Setting this flag to FALSE will force the analysis to be conducted on complete data.}

\item{digits}{Number of digits shown in the HTML report.}

\item{HTML_report}{A boolean specifying if the HTML will be saved in the R working directory.}

\item{summary_report}{A boolean specifying if a summary report will be printed.}

\item{cores}{A numeric value specifying the number of cores to be used for the Monte Carlo simulation. If this is set to NULL (default), it will auto-detect the number of cores to be used.}
}
\value{
\code{mediate} generates a report in HTML format based on results from the mediation analysis. This report is saved in the working directory.
The followings will returned by \code{mediate}
\item{individual}{If there is no missing data or complete data analysis is performed, \code{individual} is a list containing the models for the outcome and mediators,
and also the draws for the direct and indirect effect and other relevant estimates from each of the simulation.
If multiple imputation is used for the analysis, \code{individual} is a vector of lists containing
these information from the mediation analysis conducted on each imputed dataset. Each list contains the following items.}
\item{indirect1, indirect2, indirect3}{Elements of the \code{individual} list. Vectors of draws for the indirect effect through mediators 1, 2 and 3.}
\item{direct}{Element of the \code{individual} list. Vector of draws for the direct effect of exposure.}
\item{dependence}{Element of the \code{individual} list. This is only available when there are two mediators.
Vector of draws for the effect mediated through the dependence of the mediators.}
\item{interaction}{Element of the \code{individual} list. This is only available when there are two mediators.
Vector of draws for the effect mediated through the interaction of the mediators.}
\item{total}{Element of the \code{individual} list. Vector of draws for total causal effect of the exposure.}
\item{prop1, prop2, prop3}{Elements of the \code{individual} list. Vector of draws for the proportion of effects mediated through mediator 1, 2 and 3.}
\item{ymodel}{Element of the \code{individual} list. An object of the class \code{lm} or \code{glm}, a R object containing the fit and estimate of the outcome model.}
\item{ymodel_te}{Element of the \code{individual} list. Similar to \code{ymodel}, but did not have the mediators as predictors in the model.}
\item{m1_model, m2_model, m3_model}{Elements of the \code{individual} list. Objects of the class \code{lm} or \code{glm} containing the fit and estimates of the mediator models.}
\item{m2_model_cond}{Element of the \code{individual} list. Only available when there are more than one mediator. Object of the class \code{lm} or \code{glm} similar to \code{m2_model},
but included mediator 1 as a predictor.}
\item{m3_model_cond_m1, m3_model_cond_m2, m3_model_cond_m1m2}{Element of the \code{individual} list. Only available where there are more than two mediators. Object of the class
\code{lm} or \code{glm} similar to \code{m3_model}, but with mediator 1, mediator 2 and both as predictors respectively.}
\item{combined}{If multiple imputation is used for the analysis, \code{combined} is a list containing estimates for the direct/indirect effect and relevant estimates from all simulations
across all imputed datasets. If there is no missing data, it contains lists of draws for the direct and indirect effect and relevant estimates from each of the simulation. }
\item{direct}{Element of the \code{combined} list. A vector of estimates of direct effect from all simulations in all imputed datasets. If multiple imputation is not performed,
it is a list of estimates of direct effect from all simulations.}
\item{indirect}{Element of the \code{combined} list. A list containing vectors of draws of indirect effect through mediator 1, 2 and 3 from all simulations in all imputed datasets.
If multiple imputation is not performed, it is a list of estimates of direct effect from all simulations.}
\item{total}{Element of the \code{combined} list. A vector of draws of total effect of exposure from all simulations in all imputed datasets.
If multiple imputation is not performed, it is a list of estimates of direct effect from all simulations.}
\item{prop}{Element of the \code{combined} list. A list containing vectors of draws of proportion of effects mediated through mediator 1, 2 and 3 from all simulations in all imputed datasets.
If multiple imputation is not performed, it is a list of estimates of direct effect from all simulations.}
\item{interaction}{Element of the \code{combined} list. Only available when there are two mediators. A vector of draws of effect mediated through the interaction between mediators from all simulations in all imputed datasets.
If multiple imputation is not performed, it is a list of estimates of direct effect from all simulations.}
\item{dependence}{Element of the \code{combined} list. Only available when there are two mediators. A vector of draws of effect mediated through the dependence between mediators from all simulations in all imputed dataset.
If multiple imputation is not performed, it is a list of estimates of direct effect from all simulations.}
\item{mids}{Only available if multiple imputation is used. This is the \code{mids} object from \code{mice}, the multiple imputation package by Stef van Buuren.}
\item{y_pooled_res}{Only available if multiple imputation is used. This contains the pooled model estimates from the outcome model.}
\item{m_pooled_res}{Only available if multiple imputation is used. This contains the pooled model estimates from the mediator model(s).}
\item{model_summary}{This is a formatted table for the results from the mediator and outcome models.}
\item{res_html}{This is the HTML code for the result report.}
\item{summary_text}{This is the formatted text of the result summary.}
}
\description{
Performing mediation analysis based on the interventional effect
}
\examples{

#One mediator, no HTML report.
#Set HTML_report = TRUE if a HTML report is needed.
med_res <- mediate(y = "y", med = c("m"), treat = "x", ymodel = "regression",
mmodel = c("regression"), treat_lv = 1, control_lv = 0, incint = FALSE, inc_mmint = FALSE,
conf.level = 0.9, data = sim_data, sim = 20, complete_analysis = TRUE,
HTML_report = FALSE, digits = 3, cores = 2)

\donttest{
#One mediator with exposure-mediator interaction
#Results presented in a HTML report (This is the default).
med_res <- mediate(y = "y", med = c("m"), treat = "x", ymodel = "regression",
mmodel = c("regression"), treat_lv = 1, control_lv = 0, incint = TRUE, inc_mmint = FALSE,
conf.level = 0.9, data = sim_data, sim = 1000, complete_analysis = TRUE, digits = 3)
}

#Two mediators, complete data analysis and no HTML report.
med_res <- mediate(y = "sub_misuse", med = c("dev_peer","sub_exp"), treat = "fam_int",
c = c("conflict","gender"), ymodel = "logistic regression", mmodel = c("logistic regression",
"logistic regression"), treat_lv = 1, control_lv = 0, conf.level = 0.9,
data = substance, sim = 20, complete_analysis = TRUE,
HTML_report = FALSE, digits = 3, cores = 2)

\donttest{
#Two mediators with multiple imputation (missing data are imputed by default)
#Results presented in a HTML report.
med_res <- mediate(y = "sub_misuse", med = c("dev_peer","sub_exp"), treat = "fam_int",
c = c("conflict","gender"), ymodel = "logistic regression", mmodel = c("logistic regression",
"logistic regression"), treat_lv = 1, control_lv = 0, conf.level = 0.9,
data = substance, sim = 1000, digits = 3)
}

}
