#' Citation information for host-nematode interactions
#'
#' Edgelist of known associations between insect host (`Host`) and nematode parasite (`Nematode`),
#' and associated references and indexing values. These data are smaller than `assocref`, and
#' `citation`. The variables are as follows:
#'
#' \itemize{
#'   \item ERNnem. EDWIP record number
#'   \item refCode. Index of reference obtained from `nematode` data frame
#'   \item Reference. Citation for host-nematode record
#'   \item HostSpecies. Host species
#'   \item PathogenSpecies. Nematode parasite species
#'   \item HostTaxID. Host NCBI ID number
#'   \item HostGenus. Host genus
#'   \item HostFamily. Host family
#'   \item HostOrder. Host order
#'   \item HostClass. Host class
#'   \item PathTaxID. Pathogen NCBI ID number
#'   \item PathGenus. Pathogen genus
#'   \item PathFamily. Pathogen family
#'   \item PathOrder. Pathogen order
#'   \item PathClass. Pathogen class
#'   \item PathKingdom. Pathogen kingdom
#'  }
#'
#' @docType data
#' @keywords datasets
#' @name nemaref
#' @usage data(nemaref)
#' @format A data.frame with 338 observations



"nemaref"
