% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inpdfr_ALL_quickFunctions.R
\name{getAllAnalysis}
\alias{getAllAnalysis}
\title{A quick way to compute a set of analysis from the word-occurrence data.frame.}
\usage{
getAllAnalysis(dataset, wcloud = TRUE, sumStats = TRUE, freqW = TRUE,
  corA = TRUE, clust = TRUE, metacom = TRUE)
}
\arguments{
\item{dataset}{A single word-occurrrence data.frame.}

\item{wcloud}{A logical to for word cloud analysis.}

\item{sumStats}{A logical to for summary statistics analysis.}

\item{freqW}{A logical to for word frequency analysis.}

\item{corA}{A logical to for correspondence analysis.}

\item{clust}{A logical to for cluster analysis.}

\item{metacom}{A logical to for metacommunity analysis.}
}
\value{
A set of analyses available from the \code{inpdfr} package.
}
\description{
A quick way to compute a set of analysis from the word-occurrence data.frame.
}
\examples{
\dontrun{
data("loremIpsum")
loremIpsum01 <- loremIpsum[1:100]
loremIpsum02 <- loremIpsum[101:200]
loremIpsum03 <- loremIpsum[201:300]
loremIpsum04 <- loremIpsum[301:400]
loremIpsum05 <- loremIpsum[401:500]
subDir <- "RESULTS"
dir.create(file.path(getwd(), subDir), showWarnings = FALSE)
write(x = loremIpsum01, file = "RESULTS/loremIpsum01.txt")
write(x = loremIpsum02, file = "RESULTS/loremIpsum02.txt")
write(x = loremIpsum03, file = "RESULTS/loremIpsum03.txt")
write(x = loremIpsum04, file = "RESULTS/loremIpsum04.txt")
write(x = loremIpsum05, file = "RESULTS/loremIpsum05.txt")
wordOccuDF <- getwordOccuDF(mywd = paste0(getwd(), "/RESULTS"), 
  excludeSW = FALSE)
file.remove(list.files(full.names = TRUE, 
  path = paste0(getwd(), "/RESULTS"), pattern = "loremIpsum"))
getAllAnalysis(dataset = wordOccuDF, wcloud = FALSE, sumStats = FALSE)
}
}
