% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{sim_mnl}
\alias{sim_mnl}
\title{Simulate data from a (normally mixed) multinomial logit model}
\usage{
sim_mnl(
  N,
  T = 1,
  J,
  b,
  Omega = NULL,
  seed = NULL,
  covariate = function() rnorm(n = 1, mean = 0, sd = 9)
)
}
\arguments{
\item{N}{The number of observations.}

\item{T}{The number of choice occasions with \code{T = 1} per default.}

\item{J}{The number of alternatives.}

\item{b}{The vector of coefficients.}

\item{Omega}{The covariance matrix of the normal mixing distribution. Set to \code{NULL}
(the default) for no mixing distribution.}

\item{seed}{Set a seed for the simulation.}

\item{covariate}{A function that samples the covariates. It must return a single numeric
(random) value and must not require arguments. Per default,
\code{covariate = function() rnorm(n = 1, mean = 0, sd = 9)}, i.e. covariates
are sampled from a normal distribution with mean 0 and standard deviation 9.}
}
\value{
A \code{data.frame}. The first column (\code{n}) is the identifier for the
decider, the next column (\code{t}) the identifier for the choice occasion.
Next comes the column \code{y} with the indices of the chosen alternatives.
The last columns contain the column-wise entries of \eqn{X_{nt}}.

The true model coefficients are added to the output via the attribute
\code{"true"}. Additional attributes are \code{"N"} (the number of deciders),
\code{"T"} (the number of choice occasions), \code{"J"} (the number of
alternatives), \code{"P"} (the number of choice covariates), and \code{"mix"}
(a boolean which is \code{TRUE} if \code{Omega} is not \code{NULL}).
}
\description{
Simulate data from a (normally mixed) multinomial logit model
}
\examples{
sim_mnl(N = 3, T = 2, J = 3, b = c(-2,0.5,2), Omega = diag(3))

}
\seealso{
\code{\link[=f_ll_mnp]{f_ll_mnp()}} for computing the log-likelihood of a (normally mixed)
multinomial logit model.
}
\keyword{function}
\keyword{internal}
