% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_functions.R
\name{make_inlamemi_formula}
\alias{make_inlamemi_formula}
\title{Make formula for measurement error and missing data model}
\usage{
make_inlamemi_formula(
  formula_moi,
  formula_imp,
  formula_mis = NULL,
  family_moi = "gaussian",
  error_type = "classical",
  error_variable = NULL,
  prior.beta.error,
  prior.gamma.error = NULL,
  vars = NULL
)
}
\arguments{
\item{formula_moi}{an object of class "formula", describing the main model to be fitted.}

\item{formula_imp}{an object of class "formula", describing the imputation model for the mismeasured and/or missing observations.}

\item{formula_mis}{an object of class "formula", describing the missingness model. Does not need to have a response variable, since this will always be a binary missingness indicator.}

\item{family_moi}{a string indicating the likelihood family for the model of interest (the main model).}

\item{error_type}{type of error (one or more of "classical", "berkson", "missing")}

\item{error_variable}{character vector with the name(s) of the variable(s) with error.}

\item{prior.beta.error}{parameters for the Gaussian prior for the coefficient of the error prone variable.}

\item{prior.gamma.error}{parameters for the Gaussian prior for the coefficient of the variable with missingness in the missingness model.}

\item{vars}{Results from a call to "extract_variables_from_formula" function. If this is not passed as an argument, it is called inside the function.}
}
\value{
An object of class "formula".
}
\description{
Make formula for measurement error and missing data model
}
\examples{
\dontshow{if (requireNamespace('INLA')) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
make_inlamemi_formula(formula_moi = y ~ x + z,
                      formula_imp = x ~ z,
                      error_type = "classical",
                      prior.beta.error = c(0, 1/1000)
                      )
\dontshow{\}) # examplesIf}
}
