% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_aggregated_profiles.R
\name{show_aggreagated_profiles}
\alias{show_aggreagated_profiles}
\title{Adds a Layer with Aggregated Profiles}
\usage{
show_aggreagated_profiles(x, ..., size = 0.5, alpha = 1,
  color = "#371ea3", variables = NULL)
}
\arguments{
\item{x}{a ceteris paribus explainer produced with function `ceteris_paribus()`}

\item{...}{other explainers that shall be plotted together}

\item{size}{a numeric. Size of lines to be plotted}

\item{alpha}{a numeric between 0 and 1. Opacity of lines}

\item{color}{a character. Either name of a color or name of a variable that should be used for coloring}

\item{variables}{if not NULL then only `variables` will be presented}
}
\value{
a ggplot2 layer
}
\description{
Function 'show_aggreagated_profiles' adds a layer to a plot created with 'plot.ceteris_paribus_explainer'.
}
\examples{
library("DALEX")
# Toy examples, because CRAN angels ask for them
titanic <- na.omit(titanic)
selected_passangers <- select_sample(titanic, n = 100)

model_titanic_glm <- glm(survived == "yes" ~ gender + age + fare,
                       data = titanic, family = "binomial")

explain_titanic_glm <- explain(model_titanic_glm,
                           data = titanic[,-9],
                           y = titanic$survived == "yes")

cp_rf <- ceteris_paribus(explain_titanic_glm, selected_passangers)
pdp_rf <- aggregate_profiles(cp_rf, variables = "age")
plot(cp_rf, variables = "age") +
  show_observations(cp_rf, variables = "age") +
  show_aggreagated_profiles(pdp_rf, size = 3)

 \donttest{
library("randomForest")
 model_titanic_rf <- randomForest(survived ~ gender + age + class + embarked +
                                    fare + sibsp + parch,  data = titanic)
 model_titanic_rf

 explain_titanic_rf <- explain(model_titanic_rf,
                           data = titanic[,-9],
                           y = titanic$survived)

cp_rf <- ceteris_paribus(explain_titanic_rf, selected_passangers)
cp_rf

pdp_rf <- aggregate_profiles(cp_rf, variables = "age")
head(pdp_rf)

plot(cp_rf, variables = "age") +
  show_observations(cp_rf, variables = "age") +
  show_rugs(cp_rf, variables = "age", color = "red") +
  show_aggreagated_profiles(pdp_rf, size = 3)

plot(pdp_rf, variables = "age", color = "grey")

}
}
