% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid-sp-polygons.R
\name{SpPolygons}
\alias{SpPolygons}
\alias{SpPolygons,trigrid-method}
\alias{SpPolygons,hexagrid-method}
\title{Spatial polygons from an icosahedral grid}
\usage{
SpPolygons(gridObj, ...)

\S4method{SpPolygons}{trigrid}(gridObj, res = NULL)

\S4method{SpPolygons}{hexagrid}(gridObj, res = NULL)
}
\arguments{
\item{gridObj}{(\code{\link{trigrid}} or \code{\link{hexagrid}}) An icosahedral grid.}

\item{...}{Arguments passed to class-specific methods.}

\item{res}{(\code{numeric}) The number of points inserted between two vertices, or \code{NULL}, if this is to be set by the package. The default method increases resolution with lower tessellation values, and is higher for higher absolute latitudes.}
}
\value{
A \code{\link[sp]{SpatialPolygons}} class object.
}
\description{
The function will create a \code{\link[sp]{SpatialPolygons}} class 2d representation of the icosahedral grid.
}
\examples{
a <- trigrid()
sp <- SpPolygons(a)
}
