% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-legend.R
\name{heatMapLegend}
\alias{heatMapLegend}
\title{Legend for a heatmap with predefined colors.}
\usage{
heatMapLegend(
  cols,
  vals,
  varName,
  tick.text = NULL,
  tick.cex = 1.5,
  barWidth = 3,
  barHeight = 50,
  tickLength = 1,
  xLeft = 88,
  yBot = 25,
  add = FALSE,
  bounds = c(FALSE, FALSE),
  ...
)
}
\arguments{
\item{cols}{(\code{character}) Vector, containnig the ordered colors that are used for the heatmap.}

\item{vals}{(\code{numeric}) If \code{tick.text} is missing, the lowest value in the heatmap}

\item{varName}{(\code{character}) The label of the variable name plotted to the heatmap.}

\item{tick.text}{(\code{numeric}) The values on the heatmap legend. If missing, will be calculated with \code{minVal} and \code{maxVal}.}

\item{tick.cex}{(\code{numeric}) Letter size of the values on the legend.}

\item{barWidth}{(\code{numeric}) The width (percent) of the bar featuring the colors of the heatmap.}

\item{barHeight}{(\code{numeric}) The height (percent)of the bar featuring the colors of the heatmap.}

\item{tickLength}{(\code{numeric})  The length (percent) of the ticks at the bars.}

\item{xLeft}{(\code{numeric}) The x coordinate of the lower left hand corner of the bar.}

\item{yBot}{(\code{numeric}) The y coordinate of the lower left hand corner of the bar.}

\item{add}{(\code{logical}) Indicates wheter a new plot should be drawn or not. Defaults to \code{FALSE}.}

\item{bounds}{(\code{logical}) Vector (length 2) indicating whether open intervals should be indicated for the legend.}

\item{...}{Arguments passed to the \code{\link[graphics]{plot}} function.}
}
\value{
The function does not return any value.
}
\description{
This function will invoke the \code{\link[graphics]{plot}} function to draw a heatmap legend.
}
\details{
The 'percents' refer to the plotting area measured from the lower left corner.
}
