% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{print.ichimoku}
\alias{print.ichimoku}
\title{Print Ichimoku Objects}
\usage{
\method{print}{ichimoku}(x, plot = TRUE, ...)
}
\arguments{
\item{x}{an object of class 'ichimoku'.}

\item{plot}{[default TRUE] set to FALSE to prevent automatic plotting of
the ichimoku cloud chart.}

\item{...}{additional arguments passed along to \code{\link[tibble]{print.tbl}}
and \code{\link{plot.ichimoku}} functions.}
}
\value{
The ichimoku object supplied (invisibly). The data is printed to the
    console. The ichimoku cloud chart is also output to the graphical device
    depending on the parameters set.
}
\description{
Default print method for ichimoku objects to enable automatic plotting of the
    ichimoku cloud chart.
}
\details{
This function is an S3 method for the generic function print() for
    class 'ichimoku'. It can be invoked by calling print(x) on an object 'x'
    of class 'ichimoku'.
}
\examples{
cloud <- ichimoku(sample_ohlc_data, ticker = "TKR")

print(cloud)
print(cloud, plot = FALSE, n = 20)

}
