% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Fpa.R
\name{Fpa}
\alias{Fpa}
\title{Fpa from Flim}
\usage{
Fpa(Flim, sigmaF)
}
\arguments{
\item{Flim}{the value of the Flim reference point.}

\item{sigmaF}{the estimation uncertainty in F (standard error of logF in the
terminal year).}
}
\value{
Value of Fpa.
}
\description{
Calculate the value of Fpa from Flim and sigmaF.
}
\note{
By comparing the current F to Fpa, one can answer the question: are we at
least 95\% sure that F is below Flim, given the estimation uncertainty?

The ICES (2016) technical guidelines define Fpa as:

\deqn{F_\mathrm{pa} = F_\mathrm{lim} \exp(-1.645\sigma_F)}{
      Fpa = Flim * exp(-1.645*sigmaF)}

The \code{Fpa} function can also be used to evaluate reference points based
on harvest rate: Hpa from Hlim and sigmaH.
}
\examples{
Fpa(0.90, 0.15)

}
\author{
Arni Magnusson.
}
\references{
ICES. 2016. Advice Technical Guidelines: ICES fisheries management reference
points for category 1 stocks. \cite{Draft document version 30 (2016-04-21),
available at the ACOM Meetings area on the ICES Sharepoint.}
}
\seealso{
\code{\link{Bpa}} calculates that reference point from Blim and sigmaB.

\code{\link{sigmaPA}} calculates the implicit sigma from PA reference points.

\code{\link{icesAdvice-package}} gives an overview of the package.
}
\keyword{distribution}

