% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heuristics.R
\name{predict.glmnetcv_learner}
\alias{predict.glmnetcv_learner}
\title{Return the predictions made by a GLMNet learner for each point in the
features}
\usage{
\method{predict}{glmnetcv_learner}(obj, X, fit_index = NULL, ...)
}
\arguments{
\item{obj}{The learner or grid to use for prediction.}

\item{X}{The features of the data.}

\item{fit_index}{The index of the fit in the path to use for prediction,
defaulting to the best fit if not supplied.}

\item{...}{Refer to the Julia documentation for available parameters.}
}
\description{
Julia Equivalent:
\href{https://docs.interpretable.ai/v3.2.1/Heuristics/reference/#IAI.predict-Tuple\%7BGLMNetCVLearner\%2C\%20Union\%7BDataFrames.AbstractDataFrame\%2C\%20AbstractMatrix\%7B\%3C\%3AReal\%7D\%7D\%7D}{\code{IAI.predict}}
}
\section{IAI Compatibility}{

Requires IAI version 2.1 or higher.
}

\examples{
\dontrun{iai::predict(lnr, X)}

}
