% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimalfeatureselection.R
\name{score.optimal_feature_selection_learner}
\alias{score.optimal_feature_selection_learner}
\title{Calculate the score for an Optimal Feature Selection learner
on the given data}
\usage{
\method{score}{optimal_feature_selection_learner}(obj, X, ...)
}
\arguments{
\item{obj}{The learner or grid to evaluate.}

\item{X}{The features of the data.}

\item{...}{Other parameters, including zero or more target vectors as
required by the problem type. If the \code{coordinated_sparsity}
parameter on the learner is \code{TRUE}, then \code{fit_index}
must be used to specify which cluster should be used. Refer to
the Julia documentation for available parameters.}
}
\description{
Julia Equivalent:
\href{https://docs.interpretable.ai/v3.1.1/OptimalFeatureSelection/reference/#IAI.score-Tuple\%7BOptimalFeatureSelectionLearner\%7D}{\code{IAI.score}}
}
\section{IAI Compatibility}{

Requires IAI version 1.1 or higher.
}

\examples{
\dontrun{iai::score(lnr, X, y, fit_index=1)}

}
