% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step_earthtide.R
\name{step_earthtide}
\alias{step_earthtide}
\title{Earth tide response}
\usage{
step_earthtide(
  recipe,
  ...,
  role = "predictor",
  trained = FALSE,
  do_predict = FALSE,
  method = "gravity",
  astro_update = 1L,
  latitude = 0,
  longitude = 0,
  elevation = 0,
  azimuth = 0,
  gravity = 0,
  earth_radius = 6378136.3,
  earth_eccen = 0.0066943979514,
  cutoff = 1e-06,
  wave_groups = NULL,
  catalog = "ksm04",
  eop = NULL,
  scale = TRUE,
  prefix = "earthtide_",
  columns = NULL,
  keep_original_cols = FALSE,
  skip = FALSE,
  id = rand_id("earthtide")
)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose which
variables are affected by the step. See \code{\link[=selections]{selections()}}
for more details. For the \code{tidy} method, these are not
currently used.}

\item{role}{Defaults to "earthtide"}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{do_predict}{run in predict or analyze mode}

\item{method}{One or more of "gravity", 
"tidal_potential", "tidal_tilt", "vertical_displacement", 
"horizontal_displacement", "n_s_displacement", "e_w_displacement",
"vertical_strain", "areal_strain", "volume_strain", "horizontal_strain",
or "ocean_tides", "pole_tide", "lod_tide". The pole tide and lod_tide 
are used in predict mode even if do_predict is FALSE. More than one value
can only be used if do_predict == TRUE.}

\item{astro_update}{Integer that
determines how often to phases are updated in number of samples. Defaults
to 1 (every sample), but speed gains are realized with larger values.
Typically updating every hour will have speed gains and keep precision 
(ie 3600 for one second data, 60 for minute data, 1 for hourly data).}

\item{latitude}{The station latitude (numeric) defaults to 0.}

\item{longitude}{The station longitude (numeric) defaults to 0.}

\item{elevation}{The station elevation (m) (numeric) defaults to 0.}

\item{azimuth}{Earth azimuth (numeric) defaults to 0.}

\item{gravity}{Gravity at the station (m/s^2) (numeric) 0 to 
estimate gravity from elevation and latitude.}

\item{earth_radius}{Radius of earth (m) (numeric) defaults to 6378136.3}

\item{earth_eccen}{Eccentricity of earth (numeric) 
defaults to 6.69439795140e-3}

\item{cutoff}{Cutoff amplitude for constituents (numeric) 
defaults to 1e-6.}

\item{wave_groups}{Two column data.frame having start and end of 
frequency groups (data.frame). This data.frame must have two columns
with the names 'start', and 'end' signifying the start and end of the 
wave groupings.  An optional third column 'multiplier' can be provided 
to scale the particular wave group.  If column names do no match, the
inferred column positions are start, end, multiplier.}

\item{catalog}{Use the "hw95s" catalog or "ksm04" catalog (character).}

\item{eop}{User defined Earth Orientation Parameter (EOP) data.frame with the 
following columns: datetime, ddt, ut1_utc, lod, x, y, dx, dy}

\item{scale}{Scale results when do_predict is FALSE}

\item{prefix}{A prefix for generated column names, default to
"earthtide_".}

\item{columns}{A character string of variable names that will
be populated (eventually) by the \code{terms} argument.}

\item{keep_original_cols}{A logical to keep the original variables in the
output. Defaults to \code{FALSE}.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[recipes:bake]{bake()}}? While all operations are baked
when \code{\link[recipes:prep]{prep()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of \code{recipe} with the new step
added to the sequence of existing steps (if any).
}
\description{
\code{step_earthtide} creates a \emph{specification} of a recipe step
that are the Earth tide harmonics for a particular
location. This step requires the \href{https://CRAN.R-project.org/package=earthtide}{earthtide package}.
}
\details{
There are many waves (thousands) that make up a tidal signal.
\code{step_earthtide} calculates the Earth tide signal for a time and
location. The tidal signal can be estimated as a single summed curve when
\code{do_predict = TRUE} or as a set of wave groups when \code{do_predict = FALSE}.
Wave groups are ranges of frequencies identified by start and end
frequencies.  For example, if you have one month of data the M2 signal
could be described as the sum of all the waves between 1.914129 and
1.950419 cycles per day. The regressors for each wave group have a sin
and cos component. See \code{\link[recipes:step_harmonic]{recipes::step_harmonic()}} for a simplified
version of this where each sin and cos curve corresponds to a single wave.
}
\examples{
library(earthtide)
data(eterna_wavegroups)
data(transducer)

transducer <- transducer[, c('datetime', 'wl'),]
t_sub <- transducer[(as.numeric(transducer$datetime) \%\% 14400) == 0, ]
wg <- na.omit(eterna_wavegroups[eterna_wavegroups$time == '1 month',])

recipe(wl ~ ., data = t_sub) |>
  step_earthtide(datetime,
                 latitude = 34,
                 longitude = -118.5,
                 wave_groups = wg,
                 do_predict = FALSE) |>
  prep()

recipe(wl ~ ., data = t_sub) |>
  step_earthtide(datetime,
                 latitude = 34,
                 longitude = -118.5,
                 wave_groups = wg,
                 do_predict = TRUE) |>
  prep()

}
\seealso{
\code{\link[=step_earthtide]{step_earthtide()}} \code{\link[earthtide:calc_earthtide]{earthtide::calc_earthtide()}}
\code{\link[recipes:step_harmonic]{recipes::step_harmonic()}}
}
\concept{generate Earth tide harmonics}
\keyword{datagen}
