% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/powercalc.R
\name{simpleM}
\alias{simpleM}
\title{Calculation of effective number of independent tests}
\usage{
simpleM(mat, quant = 0.995)
}
\arguments{
\item{mat}{correlation matrix}

\item{quant}{percentage cutoff, variation of SNP data explained by
eigenvalues; default value 0.995}
}
\value{
effective number of independent tests
}
\description{
Adapted simpleM method which considers theoretical correlation
  between SNP pairs instead of composite LD values. Principal component
  decomposition yields the effective number of independent tests. This value
  is needed for the Bonferroni correction of type-I error when testing SNP
  effects based on a single-marker model.
}
\examples{
  ### correlation matrix (should depend on sire haplotypes)
  R <- AR1(100, rho = 0.1)
  ### effective number of tests
  Meff <- simpleM(R)
  ### relative effect size given heritability and number of QTL signals
  h2 <- 0.2
  nqtl <- 2
  betaSE <- sqrt(h2 / (nqtl - nqtl * h2))
  ### optimal sample size in a single-marker approach
  pwr::pwr.t.test(d = betaSE, sig.level = 0.01 / Meff, power = 0.8,
   alternative = "two.sided", type = "one.sample")
}
\references{
Gao, Starmer & Martin (2008) A multiple testing correction method for
  genetic association studies using correlated single nucleotide
  polymorphisms. Genet Epidemiol, 32:361-369.
}
