% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/histoslider.R
\name{input_histoslider}
\alias{input_histoslider}
\title{Create a histogram slider}
\usage{
input_histoslider(
  id,
  label,
  values,
  start = NULL,
  end = NULL,
  width = "100\%",
  height = 175,
  breaks = rlang::missing_arg(),
  options = list()
)
}
\arguments{
\item{id}{An input id.}

\item{label}{A label for the input (can be \code{NULL} or a string).}

\item{values}{a vector of numeric values for which the histogram is desired.}

\item{start}{A numeric value for the starting handle.}

\item{end}{A numeric value for the ending handle.}

\item{width, height}{Any valid CSS unit defining the width/height.}

\item{breaks}{determines how histogram bins are computed (see \code{\link[=hist]{hist()}} for
possible values and details).}

\item{options}{a list of \href{https://github.com/samhogg/histoslider/blob/b4ac504/src/components/Histoslider.js#L103-L125}{histoslider options}.}
}
\value{
A Shiny UI input element.
}
\description{
Creates a Shiny UI input binding to a histogram with a slider "filter"
control.
}
\examples{

if (interactive()) {
  library(shiny)
  shinyApp(
    input_histoslider("x", "Random", rnorm(100)),
    function(input, output) {
      observe(print(input$x))
    }
  )
}

}
\seealso{
\link{update_histoslider}
}
