% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umap_list.R
\name{umap_plt}
\alias{umap_plt}
\title{UMAP and K-Means Cluster Visualization}
\usage{
umap_plt(.data, .point_size = 2, .label = TRUE)
}
\arguments{
\item{.data}{The data from the \code{\link[=umap_list]{umap_list()}} function.}

\item{.point_size}{The desired size for the points of the plot.}

\item{.label}{Should \code{\link[ggrepel:geom_text_repel]{ggrepel::geom_label_repel()}} be used to display cluster
user labels.}
}
\value{
A ggplot2 UMAP Projection with clusters represented by colors.
}
\description{
Create a UMAP Projection plot.
}
\details{
This takes in \code{umap_kmeans_cluster_results_tbl} from the \code{\link[=umap_list]{umap_list()}}
function output.
}
\examples{
library(healthyR.data)
library(healthyR)
library(dplyr)
library(broom)
library(ggplot2)

data_tbl <- healthyR_data \%>\%
    filter(ip_op_flag == "I") \%>\%
    filter(payer_grouping != "Medicare B") \%>\%
    filter(payer_grouping != "?") \%>\%
    select(service_line, payer_grouping) \%>\%
    mutate(record = 1) \%>\%
    as_tibble()

uit_tbl <- kmeans_user_item_tbl(
   .data           = data_tbl
   , .row_input    = service_line
   , .col_input    =  payer_grouping
   , .record_input = record
 )

kmm_tbl <- kmeans_mapped_tbl(uit_tbl)

ump_lst <- umap_list(.data = uit_tbl, kmm_tbl, 3)

umap_plt(.data = ump_lst, .point_size = 3)

}
\seealso{
\itemize{
\item \url{https://cran.r-project.org/package=uwot} (CRAN)
\item \url{https://github.com/jlmelville/uwot} (GitHub)
\item \url{https://github.com/jlmelville/uwot} (arXiv paper)
}
}
\author{
Steven P. Sanderson II, MPH
}
