% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcma.R
\name{mediate_pcma}
\alias{mediate_pcma}
\title{Principal Component Mediation Analysis for High-dimensional Mediators}
\source{
\url{https://rdrr.io/github/zhaoyi1026/spcma}
}
\usage{
mediate_pcma(
  A,
  M,
  Y,
  var_per = 0.8,
  n_pc = NULL,
  sims = 1000,
  boot_ci_type = "bca",
  ci_level = 0.95,
  seed = 1
)
}
\arguments{
\item{A}{length \code{n} numeric vector containing exposure variable}

\item{M}{\code{n x p} numeric matrix of high-dimensional mediators.}

\item{Y}{length \code{n} numeric vector containing continuous outcome variable.}

\item{var_per}{a numeric variable with the desired proportion of variance
explained. Default is 0.8.}

\item{n_pc}{optional numeric variable with the desired number of PCs, in which case
\code{var_per} is ignored. Default is \code{NULL} and the number of PCs is
determined based on the desired proportion of variance explained.}

\item{sims}{number of Monte Carlo draws for nonparametric bootstrap or
quasi-Bayesian approximation (see \code{\link[mediation:mediate]{mediation::mediate()}}).
Default is 1000.}

\item{boot_ci_type}{a character string indicating the type of bootstrap
confidence intervals for when \code{boot = TRUE}. If \code{"bca"},
bias-corrected and accelerated (BCa) confidence intervals will be estimated.
If \code{"perc"}, percentile confidence intervals will be estimated
(see \code{\link[mediation:mediate]{mediation::mediate()}}). Default is "bca".}

\item{ci_level}{the desired confidence level. Default is 0.95.}

\item{seed}{seed used for fitting single-mediator models after PCA}
}
\value{
A list containing:
\itemize{
\item \code{loadings}: a matrix of the PC loadings.
\item \code{pcs}: a matrix of the PCs.
\item \code{var_explained}: the cumulative proportion of variance explained by the PCs.
\item \code{contributions}: a data frame containing the estimates, confidence
intervals, and p-values of the mediation contributions.
\item \code{effects}: a data frame containing the estimated direct, global
mediation, and total effects.
}
}
\description{
\code{mediate_pcma} applies principal component mediation analysis
(Huang and Pan, 2013) to mediation settings in which the mediators are high-dimensional.
}
\details{
Principal component mediation analysis (PCMA) is a method for estimating
mediation effects when the mediators are high-dimensional. The first step
is to compute the residuals of mediator models (\eqn{M|A}), then perform
PCA on those residuals to reduce them to a smaller number of mediators
that efficiently explain the residual variance. Then, since those mediators
are linearly independent conditional on A, one can trivially perform
single-mediator mediation analysis for each PC on its own, in this case
by using the \code{\link[mediation:mediate]{mediation::mediate()}} function. The global mediation effect is estimated
by summing the mediation effects of the individual PCs.
}
\examples{
A <- med_dat$A
M <- med_dat$M
Y <- med_dat$Y
# Fit PCMA with 3 principal components and print the effects. In practice one
# should choose n_pc (or var_per) and the number sims to be larger
out <- mediate_pcma(A, M, Y, n_pc = 3, sims = 10)
out$effects



}
\references{
Huang, Y.-T. & Pan, W.-C. Hypothesis test of mediation effect in
causal mediation model with  high-dimensional continuous mediators.
Biometrics 72, 402-413 (2016).
}
